package io.smallrye.reactive.messaging.mqtt.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class MqttExceptions_$bundle implements MqttExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected MqttExceptions_$bundle() {}
    public static final MqttExceptions_$bundle INSTANCE = new MqttExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalArgumentUnknownStrategy$str() {
        return "SRMSG17000: Unknown failure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalArgumentInvalidQoS$str() {
        return "SRMSG17001: Invalid QoS value: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidQoS(final int qos) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidQoS$str(), qos));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateFindingBean$str() {
        return "SRMSG17002: Cannot find a %s bean identified with %s";
    }
    @Override
    public final IllegalStateException illegalStateFindingBean(final String className, final String beanName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateFindingBean$str(), className, beanName));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
