/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.reactive.messaging.mqtt.MqttFailureHandler;
import io.smallrye.reactive.messaging.mqtt.MqttMessage;
import io.smallrye.reactive.messaging.mqtt.ReceivingMqttMessageMetadata;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class ReceivingMqttMessage
implements MqttMessage<byte[]> {
    final MqttPublishMessage message;
    final MqttFailureHandler onNack;
    final Metadata metadata;
    private final ReceivingMqttMessageMetadata receivingMetadata;

    ReceivingMqttMessage(MqttPublishMessage message, MqttFailureHandler onNack) {
        this.message = message;
        this.onNack = onNack;
        this.receivingMetadata = new ReceivingMqttMessageMetadata(this.message);
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{this.receivingMetadata});
    }

    public byte[] getPayload() {
        return this.message.payload().getDelegate().getBytes();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public int getMessageId() {
        return this.receivingMetadata.getMessageId();
    }

    @Override
    public MqttQoS getQosLevel() {
        return this.receivingMetadata.getQosLevel();
    }

    @Override
    public boolean isDuplicate() {
        return this.receivingMetadata.isDuplicate();
    }

    @Override
    public boolean isRetain() {
        return this.receivingMetadata.isRetain();
    }

    @Override
    public String getTopic() {
        return this.receivingMetadata.getTopic();
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return this.onNack.handle(reason);
    }

    public BiFunction<Throwable, Metadata, CompletionStage<Void>> getNackWithMetadata() {
        return this::nack;
    }
}

