/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt.converter;

import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.mqtt.ReceivingMqttMessageMetadata;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import io.vertx.mqtt.messages.MqttPublishMessage;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class MqttMessageConverter
implements MessageConverter {
    public boolean canConvert(Message<?> in, Type target) {
        return in.getMetadata(ReceivingMqttMessageMetadata.class).isPresent() && TypeUtils.isAssignable((Type)target, MqttPublishMessage.class);
    }

    public Message<?> convert(Message<?> in, Type target) {
        ReceivingMqttMessageMetadata metadata = (ReceivingMqttMessageMetadata)in.getMetadata(ReceivingMqttMessageMetadata.class).orElseThrow(() -> new IllegalStateException("No MQTT metadata"));
        return in.withPayload((Object)metadata.getMessage().getDelegate());
    }
}

