/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConnectorConfig
implements Config {
    private final String prefix;
    private final Config overall;
    public static final Config EMPTY_CONFIG = new Config(){

        public <T> T getValue(String propertyName, Class<T> propertyType) {
            return null;
        }

        public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
            return Optional.empty();
        }

        public Iterable<String> getPropertyNames() {
            return Collections.emptyList();
        }

        public Iterable<ConfigSource> getConfigSources() {
            return Collections.emptyList();
        }
    };
    private final String name;
    private final boolean injectNameProperty;

    public ConnectorConfig(String prefix, Config overall, String name) {
        this.prefix = Objects.requireNonNull(prefix, "the prefix must not be set");
        this.overall = Objects.requireNonNull(overall, "the config must not be set");
        this.name = Objects.requireNonNull(name, "the name must be set");
        this.injectNameProperty = StreamSupport.stream(overall.getPropertyNames().spliterator(), false).noneMatch(s -> s.equalsIgnoreCase(prefix + ".name"));
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if ("name".equalsIgnoreCase(propertyName) && this.injectNameProperty) {
            return (T)this.name;
        }
        return (T)this.overall.getValue(this.prefix + "." + propertyName, propertyType);
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if ("name".equalsIgnoreCase(propertyName) && this.injectNameProperty) {
            return Optional.of(this.name);
        }
        return this.overall.getOptionalValue(this.prefix + "." + propertyName, propertyType);
    }

    public Iterable<String> getPropertyNames() {
        Set<String> strings = StreamSupport.stream(this.overall.getPropertyNames().spliterator(), false).filter(s -> s.startsWith(this.prefix + ".")).map(s -> s.substring((this.prefix + ".").length())).collect(Collectors.toSet());
        if (this.injectNameProperty) {
            strings.add("name");
        }
        return strings;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.overall.getConfigSources();
    }
}

