/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.spi;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.microprofile.config.Config;

public class ConfigurationHelper {
    private final Config config;

    private ConfigurationHelper(Config conf) {
        this.config = conf;
    }

    public static ConfigurationHelper create(Config conf) {
        return new ConfigurationHelper(Objects.requireNonNull(conf));
    }

    public String getOrDie(String key) {
        return (String)this.config.getOptionalValue(key, String.class).orElseThrow(() -> new IllegalArgumentException("Invalid configuration - expected key `" + key + "` to be present in " + this.config));
    }

    public String get(String key) {
        return this.config.getOptionalValue(key, String.class).orElse(null);
    }

    public String get(String key, String def) {
        return this.config.getOptionalValue(key, String.class).orElse(def);
    }

    public boolean getAsBoolean(String key, boolean def) {
        return this.config.getOptionalValue(key, Boolean.class).orElse(def);
    }

    public int getAsInteger(String key, int def) {
        return this.config.getOptionalValue(key, Integer.class).orElse(def);
    }

    public JsonObject asJsonObject() {
        JsonObject json = new JsonObject();
        Iterable propertyNames = this.config.getPropertyNames();
        for (String key : propertyNames) {
            try {
                int i = (Integer)this.config.getValue(key, Integer.class);
                json.put(key, Integer.valueOf(i));
            }
            catch (ClassCastException | NumberFormatException i) {
                try {
                    double d = (Double)this.config.getValue(key, Double.class);
                    json.put(key, Double.valueOf(d));
                }
                catch (ClassCastException | NumberFormatException d) {
                    try {
                        String value = (String)this.config.getValue(key, String.class);
                        if (value.trim().equalsIgnoreCase("false")) {
                            json.put(key, Boolean.valueOf(false));
                            continue;
                        }
                        if (value.trim().equalsIgnoreCase("true")) {
                            json.put(key, Boolean.valueOf(true));
                            continue;
                        }
                        json.put(key, (String)this.config.getValue(key, String.class));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
        return json;
    }
}

