/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.spi;

import java.util.Objects;
import org.eclipse.microprofile.config.Config;

public class ConfigurationHelper {
    private final Config config;

    private ConfigurationHelper(Config conf) {
        this.config = conf;
    }

    public static ConfigurationHelper create(Config conf) {
        return new ConfigurationHelper(Objects.requireNonNull(conf));
    }

    public String getOrDie(String key) {
        return (String)this.config.getOptionalValue(key, String.class).orElseThrow(() -> new IllegalArgumentException("Invalid configuration - expected key `" + key + "` to be present in " + this.config));
    }

    public String get(String key) {
        return this.config.getOptionalValue(key, String.class).orElse(null);
    }

    public String get(String key, String def) {
        return this.config.getOptionalValue(key, String.class).orElse(def);
    }

    public boolean getAsBoolean(String key, boolean def) {
        return this.config.getOptionalValue(key, Boolean.class).orElse(def);
    }

    public int getAsInteger(String key, int def) {
        return this.config.getOptionalValue(key, Integer.class).orElse(def);
    }
}

