/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import io.smallrye.reactive.messaging.annotations.Merge;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.inject.spi.Bean;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MediatorConfiguration {
    private final Bean<?> mediatorBean;
    private final Method method;
    private Shape shape;
    private Incoming incoming;
    private Outgoing outgoing;
    private Acknowledgment.Strategy acknowledgment;
    private Broadcast broadcast;
    private Production production = Production.NONE;
    private Consumption consumption = Consumption.NONE;
    private boolean useBuilderTypes = false;
    private Merge.Mode mergePolicy;
    private Class<? extends Invoker> invokerClass;

    public MediatorConfiguration(Method method, Bean<?> bean) {
        this.method = Objects.requireNonNull(method, "'method' must be set");
        this.mediatorBean = Objects.requireNonNull(bean, "'bean' must be set");
    }

    public Shape shape() {
        return this.shape;
    }

    public void compute(Incoming incoming, Outgoing outgoing) {
        if (incoming != null && StringUtils.isBlank((CharSequence)incoming.value())) {
            throw this.getIncomingError("value is blank or null");
        }
        if (outgoing != null && StringUtils.isBlank((CharSequence)outgoing.value())) {
            throw this.getOutgoingError("value is blank or null");
        }
        this.shape = incoming != null && outgoing != null ? (this.isReturningAPublisherOrAPublisherBuilder() && this.isConsumingAPublisherOrAPublisherBuilder() ? Shape.STREAM_TRANSFORMER : Shape.PROCESSOR) : (incoming != null ? Shape.SUBSCRIBER : Shape.PUBLISHER);
        this.processAcknowledgement(incoming);
        this.validate(incoming, outgoing);
        this.processDefaultAcknowledgement();
        this.processMerge(incoming);
        this.processBroadcast(outgoing);
    }

    private void processDefaultAcknowledgement() {
        if (this.acknowledgment == null) {
            this.acknowledgment = this.shape == Shape.STREAM_TRANSFORMER ? Acknowledgment.Strategy.PRE_PROCESSING : (this.shape == Shape.PROCESSOR && this.consumption != Consumption.PAYLOAD ? Acknowledgment.Strategy.PRE_PROCESSING : (this.shape == Shape.SUBSCRIBER && (this.consumption == Consumption.STREAM_OF_PAYLOAD || this.consumption == Consumption.STREAM_OF_MESSAGE) ? Acknowledgment.Strategy.PRE_PROCESSING : Acknowledgment.Strategy.POST_PROCESSING));
        }
    }

    private void validate(Incoming incoming, Outgoing outgoing) {
        switch (this.shape) {
            case SUBSCRIBER: {
                this.validateSubscriber(incoming);
                break;
            }
            case PUBLISHER: {
                this.validatePublisher(outgoing);
                break;
            }
            case PROCESSOR: {
                this.validateProcessor(incoming, outgoing);
                break;
            }
            case STREAM_TRANSFORMER: {
                this.validateStreamTransformer(incoming, outgoing);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown shape: " + (Object)((Object)this.shape));
            }
        }
    }

    private void processBroadcast(Outgoing outgoing) {
        Broadcast bc = this.method.getAnnotation(Broadcast.class);
        if (outgoing != null) {
            this.broadcast = bc;
        } else if (bc != null) {
            throw this.getIncomingError("The @Broadcast annotation is only supported for method annotated with @Outgoing: " + this.methodAsString());
        }
    }

    private void processMerge(Incoming incoming) {
        Merge merge = this.method.getAnnotation(Merge.class);
        if (incoming != null) {
            if (merge != null) {
                this.mergePolicy = merge.value();
            }
        } else if (merge != null) {
            throw this.getOutgoingError("The @Merge annotation is only supported for method annotated with @Incoming: " + this.methodAsString());
        }
    }

    private void processAcknowledgement(Incoming incoming) {
        Acknowledgment annotation = this.method.getAnnotation(Acknowledgment.class);
        if (incoming != null) {
            if (annotation != null) {
                this.acknowledgment = annotation.value();
            }
        } else if (annotation != null) {
            throw this.getOutgoingError("The @Acknowledgment annotation is only supported for method annotated with @Incoming: " + this.methodAsString());
        }
    }

    private void validateStreamTransformer(Incoming incoming, Outgoing outgoing) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.validateMethodConsumingAndProducingAPublisher();
    }

    private void validateProcessor(Incoming incoming, Outgoing outgoing) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        Class<?> returnType = this.method.getReturnType();
        if (ClassUtils.isAssignable(returnType, Processor.class) || ClassUtils.isAssignable(returnType, ProcessorBuilder.class)) {
            this.validateMethodReturningAProcessor();
        } else if (ClassUtils.isAssignable(returnType, Publisher.class) || ClassUtils.isAssignable(returnType, PublisherBuilder.class)) {
            if (this.method.getParameterCount() != 1) {
                throw new IllegalArgumentException("Invalid method annotated with @Outgoing and @Incoming " + this.methodAsString() + " - one parameter expected");
            }
            this.validateMethodConsumingSingleAndProducingAPublisher();
        } else {
            Class<?> param = this.method.getParameterTypes()[0];
            if (ClassUtils.isAssignable(returnType, CompletionStage.class)) {
                Type type = this.getParameterFromReturnType(this.method, 0).orElseThrow(() -> this.getIncomingAndOutgoingError("Expected a type parameter in the return CompletionStage"));
                this.production = TypeUtils.isAssignable((Type)type, Message.class) ? Production.COMPLETION_STAGE_OF_MESSAGE : Production.COMPLETION_STAGE_OF_PAYLOAD;
                this.consumption = ClassUtils.isAssignable(param, Message.class) ? Consumption.MESSAGE : Consumption.PAYLOAD;
            } else {
                this.production = ClassUtils.isAssignable(returnType, Message.class) ? Production.INDIVIDUAL_MESSAGE : Production.INDIVIDUAL_PAYLOAD;
                Consumption consumption = this.consumption = ClassUtils.isAssignable(param, Message.class) ? Consumption.MESSAGE : Consumption.PAYLOAD;
            }
        }
        if (this.production == Production.INDIVIDUAL_MESSAGE && this.acknowledgment == Acknowledgment.Strategy.POST_PROCESSING) {
            throw new IllegalStateException("Unsupported acknowledgement policy - POST_PROCESSING not supported when producing messages");
        }
    }

    private void validateMethodConsumingAndProducingAPublisher() {
        Class<?> paramClass;
        Type type = this.getParameterFromReturnType(this.method, 0).orElseThrow(() -> this.getOutgoingError("Expected a type parameter for the returned Publisher"));
        this.production = TypeUtils.isAssignable((Type)type, Message.class) ? Production.STREAM_OF_MESSAGE : Production.STREAM_OF_PAYLOAD;
        Type pType = this.getParameterFromMethodArgument(this.method, 0, 0).orElseThrow(() -> this.getIncomingError("Expected a type parameter for the consumed Publisher"));
        this.consumption = TypeUtils.isAssignable((Type)pType, Message.class) ? Consumption.STREAM_OF_MESSAGE : Consumption.STREAM_OF_PAYLOAD;
        this.useBuilderTypes = ClassUtils.isAssignable(this.method.getReturnType(), PublisherBuilder.class);
        if (this.acknowledgment == Acknowledgment.Strategy.POST_PROCESSING) {
            throw this.getIncomingAndOutgoingError("Automatic post-processing acknowledgment is not supported.");
        }
        if (this.consumption == Consumption.STREAM_OF_PAYLOAD && this.acknowledgment == Acknowledgment.Strategy.MANUAL) {
            throw this.getIncomingAndOutgoingError("Consuming a stream of payload is not supported with MANUAL acknowledgment. Use a Publisher<Message<I>> or PublisherBuilder<Message<I>> instead.");
        }
        if (this.production == Production.STREAM_OF_PAYLOAD && this.acknowledgment == Acknowledgment.Strategy.MANUAL) {
            throw this.getIncomingAndOutgoingError("Consuming a stream of payload is not supported with MANUAL acknowledgment. Use a Publisher<Message<I>> or PublisherBuilder<Message<I>> instead.");
        }
        if (this.useBuilderTypes && !ClassUtils.isAssignable(paramClass = this.method.getParameterTypes()[0], PublisherBuilder.class)) {
            throw this.getIncomingAndOutgoingError("If the method produces a PublisherBuilder, it needs to consume a PublisherBuilder.");
        }
    }

    private void validateMethodConsumingSingleAndProducingAPublisher() {
        Type type = this.getParameterFromReturnType(this.method, 0).orElseThrow(() -> this.getOutgoingError("Expected a type parameter for the returned Publisher"));
        this.production = TypeUtils.isAssignable((Type)type, Message.class) ? Production.STREAM_OF_MESSAGE : Production.STREAM_OF_PAYLOAD;
        this.consumption = ClassUtils.isAssignable(this.method.getParameterTypes()[0], Message.class) ? Consumption.STREAM_OF_MESSAGE : Consumption.STREAM_OF_PAYLOAD;
        this.useBuilderTypes = ClassUtils.isAssignable(this.method.getReturnType(), PublisherBuilder.class);
    }

    private void validateMethodReturningAProcessor() {
        if (this.method.getParameterCount() != 0) {
            throw this.getIncomingAndOutgoingError("the method must not have parameters");
        }
        Type type1 = this.getParameterFromReturnType(this.method, 0).orElseThrow(() -> this.getIncomingAndOutgoingError("Expected 2 type parameters for the returned Processor"));
        this.consumption = TypeUtils.isAssignable((Type)type1, Message.class) ? Consumption.STREAM_OF_MESSAGE : Consumption.STREAM_OF_PAYLOAD;
        Type type2 = this.getParameterFromReturnType(this.method, 1).orElseThrow(() -> this.getIncomingAndOutgoingError("Expected 2 type parameters for the returned Processor"));
        this.production = TypeUtils.isAssignable((Type)type2, Message.class) ? Production.STREAM_OF_MESSAGE : Production.STREAM_OF_PAYLOAD;
        this.useBuilderTypes = ClassUtils.isAssignable(this.method.getReturnType(), ProcessorBuilder.class);
    }

    private Optional<Type> getParameterFromReturnType(Method method, int index) {
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return Optional.empty();
        }
        Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
        if (arguments.length >= index + 1) {
            return Optional.of(arguments[0]);
        }
        return Optional.empty();
    }

    private Optional<Type> getParameterFromMethodArgument(Method method, int argIndex, int index) {
        Type[] types = method.getGenericParameterTypes();
        if (types.length < argIndex) {
            return Optional.empty();
        }
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return Optional.empty();
        }
        Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
        if (arguments.length >= index + 1) {
            return Optional.of(arguments[0]);
        }
        return Optional.empty();
    }

    private void validatePublisher(Outgoing outgoing) {
        this.outgoing = outgoing;
        Class<?> returnType = this.method.getReturnType();
        Type type = this.method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (returnType == Void.TYPE) {
            throw this.getOutgoingError("the method must not be `void`");
        }
        if (this.method.getParameterCount() != 0) {
            throw this.getOutgoingError("no parameters expected");
        }
        this.consumption = Consumption.NONE;
        if (ClassUtils.isAssignable(returnType, Publisher.class)) {
            this.production = TypeUtils.isAssignable((Type)type, Message.class) ? Production.STREAM_OF_MESSAGE : Production.STREAM_OF_PAYLOAD;
            return;
        }
        if (ClassUtils.isAssignable(returnType, PublisherBuilder.class)) {
            this.production = TypeUtils.isAssignable((Type)type, Message.class) ? Production.STREAM_OF_MESSAGE : Production.STREAM_OF_PAYLOAD;
            this.useBuilderTypes = true;
            return;
        }
        if (ClassUtils.isAssignable(returnType, Message.class)) {
            this.production = Production.INDIVIDUAL_MESSAGE;
            return;
        }
        if (ClassUtils.isAssignable(returnType, CompletionStage.class)) {
            Type t = this.getParameterFromReturnType(this.method, 0).orElseThrow(() -> this.getOutgoingError("expected a parameter for the returned CompletionStage"));
            this.production = TypeUtils.isAssignable((Type)t, Message.class) ? Production.COMPLETION_STAGE_OF_MESSAGE : Production.COMPLETION_STAGE_OF_PAYLOAD;
            return;
        }
        this.production = Production.INDIVIDUAL_PAYLOAD;
    }

    private IllegalArgumentException getOutgoingError(String message) {
        return new IllegalArgumentException("Invalid method annotated with @Outgoing: " + this.methodAsString() + " - " + message);
    }

    private IllegalArgumentException getIncomingError(String message) {
        return new IllegalArgumentException("Invalid method annotated with @Incoming: " + this.methodAsString() + " - " + message);
    }

    private IllegalArgumentException getIncomingAndOutgoingError(String message) {
        return new IllegalArgumentException("Invalid method annotated with @Incoming and @Outgoing: " + this.methodAsString() + " - " + message);
    }

    private void validateSubscriber(Incoming incoming) {
        this.incoming = incoming;
        this.production = Production.NONE;
        Class<?> returnType = this.method.getReturnType();
        Optional<Type> type = this.getParameterFromReturnType(this.method, 0);
        if (ClassUtils.isAssignable(returnType, Subscriber.class) || ClassUtils.isAssignable(returnType, SubscriberBuilder.class)) {
            if (this.method.getParameterCount() != 0) {
                throw this.getIncomingError("when returning a Subscriber or a SubscriberBuilder, no parameters are expected");
            }
            Type p = type.orElseThrow(() -> this.getIncomingError("the returned Subscriber must declare a type parameter"));
            this.consumption = TypeUtils.isAssignable((Type)p, Message.class) ? Consumption.STREAM_OF_MESSAGE : Consumption.STREAM_OF_PAYLOAD;
            return;
        }
        if (ClassUtils.isAssignable(returnType, CompletionStage.class)) {
            if (this.method.getParameterCount() != 1) {
                throw this.getIncomingError("when returning a CompletionStage, one parameter is expected");
            }
            Class<?> param = this.method.getParameterTypes()[0];
            this.consumption = ClassUtils.isAssignable(param, Message.class) ? Consumption.MESSAGE : Consumption.PAYLOAD;
            return;
        }
        if (this.method.getParameterCount() == 1) {
            Class<?> param = this.method.getParameterTypes()[0];
            Consumption consumption = this.consumption = ClassUtils.isAssignable(param, Message.class) ? Consumption.MESSAGE : Consumption.PAYLOAD;
            if (this.consumption == Consumption.MESSAGE) {
                throw this.getIncomingError("The signature is not supported as it requires 'blocking' acknowledgment, return a CompletionStage<Message<?> instead.");
            }
            return;
        }
        throw this.getIncomingError("Unsupported signature");
    }

    public String getOutgoing() {
        if (this.outgoing == null) {
            return null;
        }
        return this.outgoing.value();
    }

    public String getIncoming() {
        if (this.incoming == null) {
            return null;
        }
        return this.incoming.value();
    }

    public String methodAsString() {
        return this.mediatorBean.getBeanClass().getName() + "#" + this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Consumption consumption() {
        return this.consumption;
    }

    public Production production() {
        return this.production;
    }

    public boolean usesBuilderTypes() {
        return this.useBuilderTypes;
    }

    private boolean isReturningAPublisherOrAPublisherBuilder() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(returnType, Publisher.class) || ClassUtils.isAssignable(returnType, PublisherBuilder.class);
    }

    private boolean isConsumingAPublisherOrAPublisherBuilder() {
        Class<?>[] types = this.method.getParameterTypes();
        if (types.length >= 1) {
            Class<?> type = types[0];
            return ClassUtils.isAssignable(type, Publisher.class) || ClassUtils.isAssignable(type, PublisherBuilder.class);
        }
        return false;
    }

    public Acknowledgment.Strategy getAcknowledgment() {
        return this.acknowledgment;
    }

    public Merge.Mode getMerge() {
        return this.mergePolicy;
    }

    public boolean getBroadcast() {
        return this.broadcast != null;
    }

    public Bean<?> getBean() {
        return this.mediatorBean;
    }

    public int getNumberOfSubscriberBeforeConnecting() {
        if (!this.getBroadcast()) {
            return -1;
        }
        return this.broadcast.value();
    }

    public Class<? extends Invoker> getInvokerClass() {
        return this.invokerClass;
    }

    public static enum Consumption {
        STREAM_OF_MESSAGE,
        STREAM_OF_PAYLOAD,
        MESSAGE,
        PAYLOAD,
        NONE;

    }

    public static enum Production {
        STREAM_OF_MESSAGE,
        STREAM_OF_PAYLOAD,
        INDIVIDUAL_PAYLOAD,
        INDIVIDUAL_MESSAGE,
        COMPLETION_STAGE_OF_PAYLOAD,
        COMPLETION_STAGE_OF_MESSAGE,
        NONE;

    }
}

