/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.helpers.ClassUtils;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.DefinitionException;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MediatorConfigurationSupport {
    private final String methodAsString;
    private final Class<?> returnType;
    private final Class<?>[] parameterTypes;
    private final GenericTypeAssignable returnTypeAssignable;
    private final GenericTypeAssignable firstMethodParamTypeAssignable;
    private final boolean strict;

    public MediatorConfigurationSupport(String methodAsString, Class<?> returnType, Class<?>[] parameterTypes, GenericTypeAssignable returnTypeAssignable, GenericTypeAssignable firstMethodParamTypeAssignable, boolean strictMode) {
        this.methodAsString = methodAsString;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.returnTypeAssignable = returnTypeAssignable;
        this.firstMethodParamTypeAssignable = firstMethodParamTypeAssignable;
        this.strict = strictMode;
    }

    public Shape determineShape(List<?> incomingValue, Object outgoingValue) {
        if (!incomingValue.isEmpty() && outgoingValue != null) {
            if (this.isPublisherOrPublisherBuilder(this.returnType) && this.isConsumingAPublisherOrAPublisherBuilder(this.parameterTypes)) {
                return Shape.STREAM_TRANSFORMER;
            }
            return Shape.PROCESSOR;
        }
        if (!incomingValue.isEmpty()) {
            return Shape.SUBSCRIBER;
        }
        return Shape.PUBLISHER;
    }

    private boolean isPublisherOrPublisherBuilder(Class<?> returnType) {
        return ClassUtils.isAssignable(returnType, Publisher.class) || ClassUtils.isAssignable(returnType, PublisherBuilder.class);
    }

    private boolean isConsumingAPublisherOrAPublisherBuilder(Class[] parameterTypes) {
        if (parameterTypes.length >= 1) {
            Class type = parameterTypes[0];
            return ClassUtils.isAssignable(type, Publisher.class) || ClassUtils.isAssignable(type, PublisherBuilder.class);
        }
        return false;
    }

    public Acknowledgment.Strategy processSuppliedAcknowledgement(List<?> incomings, Supplier<Acknowledgment.Strategy> supplier) {
        Acknowledgment.Strategy result = supplier.get();
        if (!incomings.isEmpty()) {
            return result;
        }
        if (result != null) {
            throw this.getOutgoingError("The @Acknowledgment annotation is only supported for method annotated with @Incoming: " + this.methodAsString);
        }
        return null;
    }

    public ValidationOutput validate(Shape shape, Acknowledgment.Strategy acknowledgment) {
        switch (shape) {
            case SUBSCRIBER: {
                return this.validateSubscriber();
            }
            case PUBLISHER: {
                return this.validatePublisher();
            }
            case PROCESSOR: {
                return this.validateProcessor(acknowledgment);
            }
            case STREAM_TRANSFORMER: {
                return this.validateStreamTransformer(acknowledgment);
            }
        }
        throw new IllegalStateException("Unknown shape: " + shape);
    }

    private ValidationOutput validateSubscriber() {
        MediatorConfiguration.Production production = MediatorConfiguration.Production.NONE;
        if (ClassUtils.isAssignable(this.returnType, Subscriber.class) || ClassUtils.isAssignable(this.returnType, SubscriberBuilder.class)) {
            if (this.parameterTypes.length != 0) {
                throw this.getIncomingError("when returning a Subscriber or a SubscriberBuilder, no parameters are expected");
            }
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw this.getIncomingError("the returned Subscriber must declare a type parameter");
            }
            MediatorConfiguration.Consumption consumption = assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
            return new ValidationOutput(production, consumption);
        }
        if (ClassUtils.isAssignable(this.returnType, CompletionStage.class)) {
            if (this.parameterTypes.length != 1) {
                throw this.getIncomingError("when returning a CompletionStage, one parameter is expected");
            }
            return new ValidationOutput(production, ClassUtils.isAssignable(this.parameterTypes[0], Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD);
        }
        if (this.parameterTypes.length == 1) {
            MediatorConfiguration.Consumption consumption;
            Class<?> param = this.parameterTypes[0];
            MediatorConfiguration.Consumption consumption2 = consumption = ClassUtils.isAssignable(param, Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD;
            if (consumption == MediatorConfiguration.Consumption.MESSAGE) {
                throw this.getIncomingError("The signature is not supported as it requires 'blocking' acknowledgment, return a CompletionStage<Message<?> instead.");
            }
            return new ValidationOutput(production, consumption);
        }
        throw this.getIncomingError("Unsupported signature");
    }

    private ValidationOutput validatePublisher() {
        MediatorConfiguration.Consumption consumption = MediatorConfiguration.Consumption.NONE;
        if (this.returnType == Void.TYPE) {
            throw this.getOutgoingError("the method must not be `void`");
        }
        if (this.parameterTypes.length != 0) {
            throw this.getOutgoingError("no parameters expected");
        }
        if (ClassUtils.isAssignable(this.returnType, Publisher.class)) {
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw this.getOutgoingError("the returned Publisher must declare a type parameter");
            }
            return new ValidationOutput(assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD, consumption);
        }
        if (ClassUtils.isAssignable(this.returnType, PublisherBuilder.class)) {
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw this.getOutgoingError("the returned Publisher must declare a type parameter");
            }
            return new ValidationOutput(assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD, consumption, true);
        }
        if (ClassUtils.isAssignable(this.returnType, Message.class)) {
            return new ValidationOutput(MediatorConfiguration.Production.INDIVIDUAL_MESSAGE, consumption);
        }
        if (ClassUtils.isAssignable(this.returnType, CompletionStage.class)) {
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw this.getOutgoingError("the returned Publisher must declare a type parameter");
            }
            return new ValidationOutput(assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.COMPLETION_STAGE_OF_MESSAGE : MediatorConfiguration.Production.COMPLETION_STAGE_OF_PAYLOAD, consumption);
        }
        return new ValidationOutput(MediatorConfiguration.Production.INDIVIDUAL_PAYLOAD, consumption);
    }

    private ValidationOutput validateProcessor(Acknowledgment.Strategy acknowledgment) {
        MediatorConfiguration.Production production;
        MediatorConfiguration.Consumption consumption;
        Boolean useBuilderTypes = null;
        if (ClassUtils.isAssignable(this.returnType, Processor.class) || ClassUtils.isAssignable(this.returnType, ProcessorBuilder.class)) {
            if (this.parameterTypes.length != 0) {
                throw this.getIncomingAndOutgoingError("the method must not have parameters");
            }
            GenericTypeAssignable.Result firstGenericParamOfReturn = this.returnTypeAssignable.check(Message.class, 0);
            if (firstGenericParamOfReturn == GenericTypeAssignable.Result.NotGeneric) {
                throw this.getIncomingAndOutgoingError("Expected 2 type parameters for the returned Processor");
            }
            consumption = firstGenericParamOfReturn == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
            GenericTypeAssignable.Result secondGenericParamOfReturn = this.returnTypeAssignable.check(Message.class, 1);
            if (secondGenericParamOfReturn == GenericTypeAssignable.Result.NotGeneric) {
                throw this.getIncomingAndOutgoingError("Expected 2 type parameters for the returned Processor");
            }
            production = secondGenericParamOfReturn == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD;
            useBuilderTypes = ClassUtils.isAssignable(this.returnType, ProcessorBuilder.class);
        } else if (ClassUtils.isAssignable(this.returnType, Publisher.class) || ClassUtils.isAssignable(this.returnType, PublisherBuilder.class)) {
            if (this.parameterTypes.length != 1) {
                throw new IllegalArgumentException("Invalid method annotated with @Outgoing and @Incoming " + this.methodAsString + " - one parameter expected");
            }
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw this.getOutgoingError("Expected a type parameter for the returned Publisher");
            }
            production = assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD;
            consumption = ClassUtils.isAssignable(this.parameterTypes[0], Message.class) ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
            useBuilderTypes = ClassUtils.isAssignable(this.returnType, PublisherBuilder.class);
        } else {
            Class<?> param = this.parameterTypes[0];
            if (ClassUtils.isAssignable(this.returnType, CompletionStage.class)) {
                GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
                if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                    throw this.getIncomingAndOutgoingError("Expected a type parameter in the return CompletionStage");
                }
                production = assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.COMPLETION_STAGE_OF_MESSAGE : MediatorConfiguration.Production.COMPLETION_STAGE_OF_PAYLOAD;
                consumption = ClassUtils.isAssignable(param, Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD;
            } else {
                production = ClassUtils.isAssignable(this.returnType, Message.class) ? MediatorConfiguration.Production.INDIVIDUAL_MESSAGE : MediatorConfiguration.Production.INDIVIDUAL_PAYLOAD;
                MediatorConfiguration.Consumption consumption2 = consumption = ClassUtils.isAssignable(param, Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD;
            }
        }
        if (production == MediatorConfiguration.Production.INDIVIDUAL_MESSAGE && acknowledgment == Acknowledgment.Strategy.POST_PROCESSING) {
            throw new IllegalStateException("Unsupported acknowledgement policy - POST_PROCESSING not supported when producing messages");
        }
        return new ValidationOutput(production, consumption, useBuilderTypes);
    }

    private ValidationOutput validateStreamTransformer(Acknowledgment.Strategy acknowledgment) {
        Class<?> paramClass;
        GenericTypeAssignable.Result returnTypeGenericCheck = this.returnTypeAssignable.check(Message.class, 0);
        if (returnTypeGenericCheck == GenericTypeAssignable.Result.NotGeneric) {
            throw this.getOutgoingError("Expected a type parameter for the returned Publisher");
        }
        MediatorConfiguration.Production production = returnTypeGenericCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD;
        GenericTypeAssignable.Result firstParamTypeGenericCheck = this.firstMethodParamTypeAssignable.check(Message.class, 0);
        if (firstParamTypeGenericCheck == GenericTypeAssignable.Result.NotGeneric) {
            throw this.getIncomingError("Expected a type parameter for the consumed Publisher");
        }
        MediatorConfiguration.Consumption consumption = firstParamTypeGenericCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
        Boolean useBuilderTypes = ClassUtils.isAssignable(this.returnType, PublisherBuilder.class);
        if (acknowledgment == Acknowledgment.Strategy.POST_PROCESSING) {
            throw this.getIncomingAndOutgoingError("Automatic post-processing acknowledgment is not supported.");
        }
        if (consumption == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD && acknowledgment == Acknowledgment.Strategy.MANUAL) {
            throw this.getIncomingAndOutgoingError("Consuming a stream of payload is not supported with MANUAL acknowledgment. Use a Publisher<Message<I>> or PublisherBuilder<Message<I>> instead.");
        }
        if (production == MediatorConfiguration.Production.STREAM_OF_PAYLOAD && acknowledgment == Acknowledgment.Strategy.MANUAL) {
            throw this.getIncomingAndOutgoingError("Consuming a stream of payload is not supported with MANUAL acknowledgment. Use a Publisher<Message<I>> or PublisherBuilder<Message<I>> instead.");
        }
        if (useBuilderTypes.booleanValue() && !ClassUtils.isAssignable(paramClass = this.parameterTypes[0], PublisherBuilder.class)) {
            throw this.getIncomingAndOutgoingError("If the method produces a PublisherBuilder, it needs to consume a PublisherBuilder.");
        }
        return new ValidationOutput(production, consumption, useBuilderTypes);
    }

    public Acknowledgment.Strategy processDefaultAcknowledgement(Shape shape, MediatorConfiguration.Consumption consumption) {
        if (shape == Shape.STREAM_TRANSFORMER) {
            return Acknowledgment.Strategy.PRE_PROCESSING;
        }
        if (shape == Shape.PROCESSOR && consumption != MediatorConfiguration.Consumption.PAYLOAD) {
            return Acknowledgment.Strategy.PRE_PROCESSING;
        }
        if (shape == Shape.SUBSCRIBER && (consumption == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD || consumption == MediatorConfiguration.Consumption.STREAM_OF_MESSAGE)) {
            return Acknowledgment.Strategy.PRE_PROCESSING;
        }
        return Acknowledgment.Strategy.POST_PROCESSING;
    }

    public Merge.Mode processMerge(List<?> incomings, Supplier<Merge.Mode> supplier) {
        Merge.Mode result = supplier.get();
        if (incomings != null && !incomings.isEmpty()) {
            return result;
        }
        if (result != null) {
            throw this.getOutgoingError("The @Merge annotation is only supported for method annotated with @Incoming: " + this.methodAsString);
        }
        return null;
    }

    public Integer processBroadcast(Object outgoing, Supplier<Integer> supplier) {
        Integer result = supplier.get();
        if (outgoing != null) {
            return result;
        }
        if (result != null) {
            throw this.getIncomingError("The @Broadcast annotation is only supported for method annotated with @Outgoing: " + this.methodAsString);
        }
        return null;
    }

    private DefinitionException getOutgoingError(String message) {
        return new DefinitionException("Invalid method annotated with @Outgoing: " + this.methodAsString + " - " + message);
    }

    private DefinitionException getIncomingError(String message) {
        return new DefinitionException("Invalid method annotated with @Incoming: " + this.methodAsString + " - " + message);
    }

    private DefinitionException getIncomingAndOutgoingError(String message) {
        return new DefinitionException("Invalid method annotated with @Incoming and @Outgoing: " + this.methodAsString + " - " + message);
    }

    public static interface GenericTypeAssignable {
        public Result check(Class<?> var1, int var2);

        public static enum Result {
            NotGeneric,
            InvalidIndex,
            NotAssignable,
            Assignable;

        }
    }

    public static class ValidationOutput {
        private final MediatorConfiguration.Production production;
        private final MediatorConfiguration.Consumption consumption;
        private final Boolean useBuilderTypes;

        public ValidationOutput(MediatorConfiguration.Production production, MediatorConfiguration.Consumption consumption) {
            this(production, consumption, null);
        }

        public ValidationOutput(MediatorConfiguration.Production production, MediatorConfiguration.Consumption consumption, Boolean useBuilderTypes) {
            this.production = production;
            this.consumption = consumption;
            this.useBuilderTypes = useBuilderTypes;
        }

        public MediatorConfiguration.Production getProduction() {
            return this.production;
        }

        public MediatorConfiguration.Consumption getConsumption() {
            return this.consumption;
        }

        public Boolean getUseBuilderTypes() {
            return this.useBuilderTypes;
        }
    }
}

