/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscriberWrapper<I, T>
implements Processor<T, T> {
    private final Subscriber<I> delegate;
    private final Function<T, CompletionStage<Void>> postAck;
    AtomicReference<Subscriber<? super T>> subscriber = new AtomicReference();
    private Function<T, I> mapper;

    public SubscriberWrapper(Subscriber<I> subscriber, Function<T, I> mapper, Function<T, CompletionStage<Void>> postAck) {
        this.delegate = Objects.requireNonNull(subscriber);
        this.mapper = Objects.requireNonNull(mapper);
        this.postAck = postAck;
    }

    public void subscribe(Subscriber<? super T> s) {
        if (!this.subscriber.compareAndSet(null, s)) {
            s.onSubscribe(new Subscription(){

                public void request(long n) {
                }

                public void cancel() {
                }
            });
            s.onError((Throwable)new IllegalStateException("Broadcast not supported"));
        }
    }

    public void onSubscribe(Subscription s) {
        this.delegate.onSubscribe(s);
    }

    public void onNext(T item) {
        try {
            this.delegate.onNext(this.mapper.apply(item));
            if (this.postAck != null) {
                this.postAck.apply(item).thenAccept(x -> this.subscriber.get().onNext(item));
            } else {
                this.subscriber.get().onNext(item);
            }
        }
        catch (Exception e) {
            this.subscriber.get().onError((Throwable)e);
        }
    }

    public void onError(Throwable error) {
        this.delegate.onError(error);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }
}

