/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

class ThrowingEmitter<T>
implements MultiEmitter<T> {
    private MultiEmitter<? super T> delegate;
    private AtomicLong requested;

    public static <T> Multi<T> create(Consumer<MultiEmitter<? super T>> deferred, long bufferSize) {
        BackPressureStrategy backPressureStrategy = bufferSize == 0L ? BackPressureStrategy.IGNORE : BackPressureStrategy.BUFFER;
        return Multi.createFrom().deferred(() -> {
            ThrowingEmitter throwingEmitter = new ThrowingEmitter(bufferSize);
            Consumer<MultiEmitter> consumer = emitter -> {
                throwingEmitter.delegate = emitter;
                deferred.accept(throwingEmitter);
            };
            return Multi.createFrom().emitter(consumer, backPressureStrategy).on().request(throwingEmitter::request);
        });
    }

    public ThrowingEmitter(long bufferSize) {
        this.requested = new AtomicLong(bufferSize);
    }

    public MultiEmitter<T> emit(T item) {
        long requests;
        while ((requests = this.requested.get()) > 0L && !this.requested.compareAndSet(requests, requests - 1L)) {
        }
        if (requests <= 0L) {
            throw ProviderExceptions.ex.illegalStateInsufficientDownstreamRequests();
        }
        this.delegate.emit(item);
        return this;
    }

    public void fail(Throwable failure) {
        this.delegate.fail(failure);
    }

    public void complete() {
        this.delegate.complete();
    }

    public MultiEmitter<T> onTermination(Runnable onTermination) {
        this.delegate.onTermination(onTermination);
        return this;
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public long requested() {
        return this.delegate.requested();
    }

    public void request(long requests) {
        Subscriptions.add((AtomicLong)this.requested, (long)requests);
    }
}

