/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.i18n;

import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRMSG", length=5)
public interface ProviderLogging
extends BasicLogger {
    public static final ProviderLogging log = (ProviderLogging)Logger.getMessageLogger(ProviderLogging.class, (String)"io.smallrye.reactive.messaging.provider");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=200, value="The method %s has thrown an exception")
    public void methodException(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=201, value="Error caught during the stream processing")
    public void streamProcessingException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=202, value="Created new Vertx instance")
    public void vertXInstanceCreated();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=203, value="Created worker pool named %s with concurrency of %d")
    public void workerPoolCreated(String var1, Integer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=204, value="Multiple publisher found for %s, using the merge policy `ONE` takes the first found")
    public void multiplePublisherFound(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=205, value="Strict mode enabled")
    public void strictModeEnabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=206, value="Scanning Type: %s")
    public void scanningType(Class var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=207, value="Cancel subscriptions")
    public void cancelSubscriptions();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=208, value="Deployment done... start processing")
    public void deploymentDoneStartProcessing();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=209, value="Initializing mediators")
    public void initializingMediators();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=210, value="Initializing %s")
    public void initializingMethod(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=211, value="Unable to create invoker instance of %s")
    public void unableToCreateInvoker(Class var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=212, value="Unable to initialize mediator: %s")
    public void unableToInitializeMediator(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=213, value="Registering %s as publisher %s")
    public void registeringAsPublisher(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=214, value="Registering %s as subscriber %s")
    public void registeringAsSubscriber(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=215, value="Connecting mediators")
    public void connectingMediators();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=216, value="Attempt to resolve %s")
    public void attemptToResolve(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=217, value="Connecting %s to `%s` (%s)")
    public void connectingTo(String var1, List<String> var2, PublisherBuilder var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=218, value="Connecting %s to `%s`")
    public void connectingTo(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=219, value="Impossible to bind mediators, some mediators are not connected: %s \n Available publishers: %s \n Available emitters: %s")
    public void impossibleToBindMediators(List<String> var1, Set<String> var2, Set<String> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=220, value="Connecting method %s to sink %s")
    public void connectingMethodToSink(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=221, value="%d subscribers consuming the stream %s")
    public void numberOfSubscribersConsumingStream(int var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=222, value="Connecting emitter to sink %s")
    public void connectingEmitterToSink(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=223, value="Mediator created for %s")
    public void mediatorCreated(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=224, value="Analyzing mediator bean: %s")
    public void analyzingMediatorBean(Bean var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=225, value="No subscriber for channel %s  attached to the emitter %s.%s")
    public void noSubscriberForChannelAttachedToEmitter(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=226, value="Found incoming connectors: %s")
    public void foundIncomingConnectors(List<String> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=227, value="Found outgoing connectors: %s")
    public void foundOutgoingConnectors(List<String> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=228, value="No MicroProfile Config found, skipping")
    public void skippingMPConfig();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=229, value="Channel manager initializing...")
    public void channelManagerInitializing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=230, value="Unable to create the publisher or subscriber during initialization")
    public void unableToCreatePublisherOrSubscriber(@Cause Throwable var1);
}

