/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.impl.ConnectorConfig;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.ConnectorLiteral;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

@ApplicationScoped
public class ConfiguredChannelFactory
implements ChannelRegistar {
    private final Instance<IncomingConnectorFactory> incomingConnectorFactories;
    private final Instance<OutgoingConnectorFactory> outgoingConnectorFactories;
    protected final Config config;
    protected final ChannelRegistry registry;
    @Inject
    private Instance<PublisherDecorator> publisherDecoratorInstance;

    protected ConfiguredChannelFactory() {
        this.incomingConnectorFactories = null;
        this.outgoingConnectorFactories = null;
        this.config = null;
        this.registry = null;
    }

    @Inject
    public ConfiguredChannelFactory(@Any Instance<IncomingConnectorFactory> incomingConnectorFactories, @Any Instance<OutgoingConnectorFactory> outgoingConnectorFactories, Instance<Config> config, @Any Instance<ChannelRegistry> registry, BeanManager beanManager) {
        this(incomingConnectorFactories, outgoingConnectorFactories, config, registry, beanManager, true);
    }

    ConfiguredChannelFactory(@Any Instance<IncomingConnectorFactory> incomingConnectorFactories, @Any Instance<OutgoingConnectorFactory> outgoingConnectorFactories, Instance<Config> config, @Any Instance<ChannelRegistry> registry, BeanManager beanManager, boolean logConnectors) {
        this.registry = (ChannelRegistry)registry.get();
        if (config.isUnsatisfied()) {
            this.incomingConnectorFactories = null;
            this.outgoingConnectorFactories = null;
            this.config = null;
        } else {
            this.incomingConnectorFactories = incomingConnectorFactories;
            this.outgoingConnectorFactories = outgoingConnectorFactories;
            if (logConnectors) {
                ProviderLogging.log.foundIncomingConnectors(this.getConnectors(beanManager, IncomingConnectorFactory.class));
                ProviderLogging.log.foundOutgoingConnectors(this.getConnectors(beanManager, OutgoingConnectorFactory.class));
            }
            this.config = (Config)config.stream().findFirst().orElseThrow(() -> ProviderExceptions.ex.illegalStateRetieveConfig());
        }
    }

    private List<String> getConnectors(BeanManager beanManager, Class<?> clazz) {
        return beanManager.getBeans(clazz, new Annotation[]{Any.Literal.INSTANCE}).stream().map(BeanAttributes::getQualifiers).flatMap(set -> set.stream().filter(a -> a.annotationType().equals(Connector.class))).map(annotation -> ((Connector)annotation).value()).collect(Collectors.toList());
    }

    static Map<String, ConnectorConfig> extractConfigurationFor(String prefix, Config root) {
        Iterable names = root.getPropertyNames();
        HashMap<String, ConnectorConfig> configs = new HashMap<String, ConnectorConfig>();
        names.forEach(key -> {
            if (key.startsWith(prefix)) {
                String name = key.substring(prefix.length());
                if (name.contains(".")) {
                    String tmp = name;
                    name = tmp.substring(0, tmp.indexOf(46));
                }
                configs.put(name, new ConnectorConfig(prefix, root, name));
            }
        });
        return configs;
    }

    public void initialize() {
        if (this.config == null) {
            ProviderLogging.log.skippingMPConfig();
            return;
        }
        ProviderLogging.log.channelManagerInitializing();
        Map<String, ConnectorConfig> sourceConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.incoming.", this.config);
        Map<String, ConnectorConfig> sinkConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.outgoing.", this.config);
        this.detectNameConflict(sourceConfiguration, sinkConfiguration);
        this.register(sourceConfiguration, sinkConfiguration);
    }

    private void detectNameConflict(Map<String, ConnectorConfig> sourceConfiguration, Map<String, ConnectorConfig> sinkConfiguration) {
        HashSet<String> sources = new HashSet<String>(sourceConfiguration.keySet());
        Set<String> sinks = sinkConfiguration.keySet();
        sources.retainAll(sinks);
        if (!sources.isEmpty()) {
            throw ProviderExceptions.ex.deploymentInvalidConfiguration(sources);
        }
    }

    void register(Map<String, ConnectorConfig> sourceConfiguration, Map<String, ConnectorConfig> sinkConfiguration) {
        try {
            sourceConfiguration.forEach((name, conf) -> this.registry.register(name, this.createPublisherBuilder((String)name, (Config)conf)));
            sinkConfiguration.forEach((name, conf) -> this.registry.register(name, this.createSubscriberBuilder((String)name, (Config)conf)));
        }
        catch (RuntimeException e) {
            ProviderLogging.log.unableToCreatePublisherOrSubscriber(e);
            throw e;
        }
    }

    private static String getConnectorAttribute(Config config) {
        return (String)config.getValue("connector", String.class);
    }

    private PublisherBuilder<? extends Message<?>> createPublisherBuilder(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        IncomingConnectorFactory mySourceFactory = (IncomingConnectorFactory)this.incomingConnectorFactories.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).stream().findFirst().orElseThrow(() -> ProviderExceptions.ex.illegalArgumentUnknownConnector(name));
        PublisherBuilder<? extends Message<?>> publisher = mySourceFactory.getPublisherBuilder(config);
        for (PublisherDecorator decorator : this.publisherDecoratorInstance) {
            publisher = decorator.decorate(publisher, name);
        }
        return publisher;
    }

    private SubscriberBuilder<? extends Message<?>, Void> createSubscriberBuilder(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        OutgoingConnectorFactory mySinkFactory = (OutgoingConnectorFactory)this.outgoingConnectorFactories.select(new Annotation[]{ConnectorLiteral.of((String)connector)}).stream().findFirst().orElseThrow(() -> ProviderExceptions.ex.illegalArgumentUnknownConnector(name));
        return mySinkFactory.getSubscriberBuilder(config);
    }
}

