package io.smallrye.reactive.messaging.i18n;

import java.util.Locale;
import java.io.Serializable;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.enterprise.inject.spi.Bean;
import java.lang.Integer;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.util.List;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ProviderLogging_$logger extends DelegatingBasicLogger implements ProviderLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProviderLogging_$logger.class.getName();
    public ProviderLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void methodException(final String methodAsString, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, methodException$str(), methodAsString);
    }
    protected String methodException$str() {
        return "SRMSG00200: The method %s has thrown an exception";
    }
    @Override
    public final void streamProcessingException(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, streamProcessingException$str());
    }
    protected String streamProcessingException$str() {
        return "SRMSG00201: Error caught during the stream processing";
    }
    @Override
    public final void vertXInstanceCreated() {
        super.log.logf(FQCN, INFO, null, vertXInstanceCreated$str());
    }
    protected String vertXInstanceCreated$str() {
        return "SRMSG00202: Created new Vertx instance";
    }
    @Override
    public final void workerPoolCreated(final String workerName, final Integer count) {
        super.log.logf(FQCN, INFO, null, workerPoolCreated$str(), workerName, count);
    }
    protected String workerPoolCreated$str() {
        return "SRMSG00203: Created worker pool named %s with concurrency of %d";
    }
    @Override
    public final void multiplePublisherFound(final String source) {
        super.log.logf(FQCN, WARN, null, multiplePublisherFound$str(), source);
    }
    protected String multiplePublisherFound$str() {
        return "SRMSG00204: Multiple publisher found for %s, using the merge policy `ONE` takes the first found";
    }
    @Override
    public final void strictModeEnabled() {
        super.log.logf(FQCN, DEBUG, null, strictModeEnabled$str());
    }
    protected String strictModeEnabled$str() {
        return "SRMSG00205: Strict mode enabled";
    }
    @Override
    public final void scanningType(final Class javaClass) {
        super.log.logf(FQCN, INFO, null, scanningType$str(), javaClass);
    }
    protected String scanningType$str() {
        return "SRMSG00206: Scanning Type: %s";
    }
    @Override
    public final void cancelSubscriptions() {
        super.log.logf(FQCN, INFO, null, cancelSubscriptions$str());
    }
    protected String cancelSubscriptions$str() {
        return "SRMSG00207: Cancel subscriptions";
    }
    @Override
    public final void deploymentDoneStartProcessing() {
        super.log.logf(FQCN, INFO, null, deploymentDoneStartProcessing$str());
    }
    protected String deploymentDoneStartProcessing$str() {
        return "SRMSG00208: Deployment done... start processing";
    }
    @Override
    public final void initializingMediators() {
        super.log.logf(FQCN, INFO, null, initializingMediators$str());
    }
    protected String initializingMediators$str() {
        return "SRMSG00209: Initializing mediators";
    }
    @Override
    public final void initializingMethod(final String methodAsString) {
        super.log.logf(FQCN, DEBUG, null, initializingMethod$str(), methodAsString);
    }
    protected String initializingMethod$str() {
        return "SRMSG00210: Initializing %s";
    }
    @Override
    public final void unableToCreateInvoker(final Class invokerClass, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToCreateInvoker$str(), invokerClass);
    }
    protected String unableToCreateInvoker$str() {
        return "SRMSG00211: Unable to create invoker instance of %s";
    }
    @Override
    public final void unableToInitializeMediator(final String methodAsString, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToInitializeMediator$str(), methodAsString);
    }
    protected String unableToInitializeMediator$str() {
        return "SRMSG00212: Unable to initialize mediator: %s";
    }
    @Override
    public final void registeringAsPublisher(final String methodAsString, final String outgoing) {
        super.log.logf(FQCN, DEBUG, null, registeringAsPublisher$str(), methodAsString, outgoing);
    }
    protected String registeringAsPublisher$str() {
        return "SRMSG00213: Registering %s as publisher %s";
    }
    @Override
    public final void registeringAsSubscriber(final String methodAsString, final List<String> list) {
        super.log.logf(FQCN, DEBUG, null, registeringAsSubscriber$str(), methodAsString, list);
    }
    protected String registeringAsSubscriber$str() {
        return "SRMSG00214: Registering %s as subscriber %s";
    }
    @Override
    public final void connectingMediators() {
        super.log.logf(FQCN, INFO, null, connectingMediators$str());
    }
    protected String connectingMediators$str() {
        return "SRMSG00215: Connecting mediators";
    }
    @Override
    public final void attemptToResolve(final String methodAsString) {
        super.log.logf(FQCN, INFO, null, attemptToResolve$str(), methodAsString);
    }
    protected String attemptToResolve$str() {
        return "SRMSG00216: Attempt to resolve %s";
    }
    @Override
    public final void connectingTo(final String methodAsString, final List<String> list, final PublisherBuilder publisher) {
        super.log.logf(FQCN, INFO, null, connectingTo3$str(), methodAsString, list, publisher);
    }
    protected String connectingTo3$str() {
        return "SRMSG00217: Connecting %s to `%s` (%s)";
    }
    @Override
    public final void connectingTo(final String methodAsString, final List<String> list) {
        super.log.logf(FQCN, INFO, null, connectingTo2$str(), methodAsString, list);
    }
    protected String connectingTo2$str() {
        return "SRMSG00218: Connecting %s to `%s`";
    }
    @Override
    public final void impossibleToBindMediators(final List<String> list, final Set<String> incomingNames, final Set<String> emitterNames) {
        super.log.logf(FQCN, WARN, null, impossibleToBindMediators$str(), list, incomingNames, emitterNames);
    }
    protected String impossibleToBindMediators$str() {
        return "SRMSG00219: Impossible to bind mediators, some mediators are not connected: %s \n Available publishers: %s \n Available emitters: %s";
    }
    @Override
    public final void connectingMethodToSink(final String methodAsString, final String name) {
        super.log.logf(FQCN, INFO, null, connectingMethodToSink$str(), methodAsString, name);
    }
    protected String connectingMethodToSink$str() {
        return "SRMSG00220: Connecting method %s to sink %s";
    }
    @Override
    public final void numberOfSubscribersConsumingStream(final int size, final String name) {
        super.log.logf(FQCN, WARN, null, numberOfSubscribersConsumingStream$str(), size, name);
    }
    protected String numberOfSubscribersConsumingStream$str() {
        return "SRMSG00221: %d subscribers consuming the stream %s";
    }
    @Override
    public final void connectingEmitterToSink(final String name) {
        super.log.logf(FQCN, INFO, null, connectingEmitterToSink$str(), name);
    }
    protected String connectingEmitterToSink$str() {
        return "SRMSG00222: Connecting emitter to sink %s";
    }
    @Override
    public final void mediatorCreated(final String methodAsString) {
        super.log.logf(FQCN, DEBUG, null, mediatorCreated$str(), methodAsString);
    }
    protected String mediatorCreated$str() {
        return "SRMSG00223: Mediator created for %s";
    }
    @Override
    public final void analyzingMediatorBean(final Bean<?> bean) {
        super.log.logf(FQCN, INFO, null, analyzingMediatorBean$str(), bean);
    }
    protected String analyzingMediatorBean$str() {
        return "SRMSG00224: Analyzing mediator bean: %s";
    }
    @Override
    public final void noSubscriberForChannelAttachedToEmitter(final String name, final String beanClassName, final String memberName) {
        super.log.logf(FQCN, WARN, null, noSubscriberForChannelAttachedToEmitter$str(), name, beanClassName, memberName);
    }
    protected String noSubscriberForChannelAttachedToEmitter$str() {
        return "SRMSG00225: No subscriber for channel %s  attached to the emitter %s.%s";
    }
    @Override
    public final void foundIncomingConnectors(final List<String> connectors) {
        super.log.logf(FQCN, INFO, null, foundIncomingConnectors$str(), connectors);
    }
    protected String foundIncomingConnectors$str() {
        return "SRMSG00226: Found incoming connectors: %s";
    }
    @Override
    public final void foundOutgoingConnectors(final List<String> connectors) {
        super.log.logf(FQCN, INFO, null, foundOutgoingConnectors$str(), connectors);
    }
    protected String foundOutgoingConnectors$str() {
        return "SRMSG00227: Found outgoing connectors: %s";
    }
    @Override
    public final void skippingMPConfig() {
        super.log.logf(FQCN, INFO, null, skippingMPConfig$str());
    }
    protected String skippingMPConfig$str() {
        return "SRMSG00228: No MicroProfile Config found, skipping";
    }
    @Override
    public final void channelManagerInitializing() {
        super.log.logf(FQCN, INFO, null, channelManagerInitializing$str());
    }
    protected String channelManagerInitializing$str() {
        return "SRMSG00229: Channel manager initializing...";
    }
    @Override
    public final void unableToCreatePublisherOrSubscriber(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToCreatePublisherOrSubscriber$str());
    }
    protected String unableToCreatePublisherOrSubscriber$str() {
        return "SRMSG00230: Unable to create the publisher or subscriber during initialization";
    }
    @Override
    public final void incomingChannelDisabled(final String channel) {
        super.log.logf(FQCN, WARN, null, incomingChannelDisabled$str(), channel);
    }
    protected String incomingChannelDisabled$str() {
        return "SRMSG00231: Incoming channel `%s` disabled by configuration";
    }
    @Override
    public final void outgoingChannelDisabled(final String channel) {
        super.log.logf(FQCN, WARN, null, outgoingChannelDisabled$str(), channel);
    }
    protected String outgoingChannelDisabled$str() {
        return "SRMSG00232: Outgoing channel `%s` disabled by configuration";
    }
    @Override
    public final void unableToExtractIngestedPayloadType(final String method, final String reason) {
        super.log.logf(FQCN, WARN, null, unableToExtractIngestedPayloadType$str(), method, reason);
    }
    protected String unableToExtractIngestedPayloadType$str() {
        return "SRMSG00233: Unable to extract the ingested payload type for method `%s`, the reason is: %s";
    }
    @Override
    public final void failureEmittingMessage(final Throwable t) {
        super.log.logf(FQCN, WARN, t, failureEmittingMessage$str());
    }
    protected String failureEmittingMessage$str() {
        return "SRMSG00234: Failed to emit a Message to the channel";
    }
}
