/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.wiring;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.wiring.CycleException;
import io.smallrye.reactive.messaging.wiring.OpenGraphException;
import io.smallrye.reactive.messaging.wiring.Wiring;
import io.smallrye.reactive.messaging.wiring.WiringException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Graph {
    private final Set<Wiring.Component> resolved;
    private final Set<Wiring.ConsumingComponent> unresolved;
    private final boolean isClosed;
    private final Set<Wiring.PublishingComponent> inbound;
    private final Set<Wiring.ConsumingComponent> outbound;
    private final List<Exception> errors = new ArrayList<Exception>();

    public Graph(Set<Wiring.Component> resolved, Set<Wiring.ConsumingComponent> unresolved) {
        this.resolved = resolved;
        this.unresolved = unresolved;
        this.isClosed = this.computeClosure();
        boolean strict = Boolean.parseBoolean(System.getProperty("smallrye-messaging-strict-binding", "false"));
        if (strict) {
            ProviderLogging.log.strictModeEnabled();
        }
        if (strict && !this.isClosed) {
            this.errors.add((Exception)((Object)new OpenGraphException(this.resolved, unresolved)));
        }
        this.detectCycles();
        if (!strict && !this.isClosed) {
            StringBuffer message = new StringBuffer("Some components are not connected to either downstream consumers or upstream producers:\n");
            this.resolved.stream().filter(component -> !component.isDownstreamResolved()).forEach(c -> message.append("\t- ").append(c).append(" has no downstream\n"));
            this.unresolved.stream().filter(component -> !component.isDownstreamResolved()).forEach(c -> message.append("\t- ").append(c).append(" has no downstream\n"));
            this.unresolved.stream().filter(c -> !c.isUpstreamResolved()).forEach(c -> {
                if (c.upstreams().isEmpty()) {
                    message.append("\t- ").append(c).append(" has no upstream\n");
                } else {
                    message.append("\t- ").append(c).append(" does not have all its requested upstreams: ").append(c.upstreams()).append("\n");
                }
            });
            ProviderLogging.log.reportWiringFailures(message.toString());
        }
        this.inbound = this.resolved.stream().filter(c -> c.isUpstreamResolved() && c.upstreams().isEmpty() && this.isDownstreamFullyResolved((Wiring.Component)c)).map(c -> (Wiring.PublishingComponent)c).collect(Collectors.toSet());
        this.outbound = this.resolved.stream().filter(c -> c.isDownstreamResolved() && c.downstreams().isEmpty() && this.isUpstreamFullyResolved((Wiring.Component)c)).map(c -> (Wiring.ConsumingComponent)c).collect(Collectors.toSet());
        for (Wiring.Component component2 : this.resolved) {
            try {
                component2.validate();
            }
            catch (WiringException e) {
                this.errors.add((Exception)((Object)e));
            }
        }
    }

    public List<Exception> getWiringErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void materialize(ChannelRegistry registry) {
        ProviderLogging.log.startMaterialization();
        long begin = System.nanoTime();
        HashSet<Wiring.Component> materialized = new HashSet<Wiring.Component>();
        ArrayList<Wiring.PublishingComponent> current = new ArrayList<Wiring.PublishingComponent>(this.inbound);
        while (!current.isEmpty()) {
            ArrayList<Wiring.Component> downstreams = new ArrayList<Wiring.Component>();
            for (Wiring.Component component : current) {
                if (materialized.contains(component) || !this.allUpstreamsMaterialized(component, materialized)) continue;
                component.materialize(registry);
                downstreams.addAll(component.downstreams());
                materialized.add(component);
            }
            current.removeAll(materialized);
            current.addAll(downstreams);
        }
        long duration = System.nanoTime() - begin;
        ProviderLogging.log.materializationCompleted(duration);
    }

    private boolean allUpstreamsMaterialized(Wiring.Component cmp, Set<Wiring.Component> materialized) {
        for (Wiring.Component upstream : cmp.upstreams()) {
            if (materialized.contains(upstream)) continue;
            return false;
        }
        return true;
    }

    public Set<Wiring.Component> getResolvedComponents() {
        return this.resolved;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Set<Wiring.PublishingComponent> getInbound() {
        return this.inbound;
    }

    public Set<Wiring.ConsumingComponent> getOutbound() {
        return this.outbound;
    }

    private boolean isUpstreamFullyResolved(Wiring.Component component) {
        if (!component.isUpstreamResolved()) {
            return false;
        }
        for (Wiring.Component upstream : component.upstreams()) {
            if (this.isUpstreamFullyResolved(upstream)) continue;
            return false;
        }
        return true;
    }

    private boolean isDownstreamFullyResolved(Wiring.Component component) {
        if (!component.isDownstreamResolved()) {
            return false;
        }
        for (Wiring.Component downstream : component.downstreams()) {
            if (this.isDownstreamFullyResolved(downstream)) continue;
            return false;
        }
        return true;
    }

    public Set<Wiring.ConsumingComponent> getUnresolvedComponents() {
        return Collections.unmodifiableSet(this.unresolved);
    }

    public boolean hasWiringErrors() {
        return !this.errors.isEmpty();
    }

    private boolean computeClosure() {
        if (!this.unresolved.isEmpty()) {
            return false;
        }
        for (Wiring.Component component : this.resolved) {
            if (!component.isUpstreamResolved()) {
                return false;
            }
            if (!(component instanceof Wiring.InboundConnectorComponent) && !component.isDownstreamResolved()) {
                return false;
            }
            if (!(component instanceof Wiring.InboundConnectorComponent) || component.isDownstreamResolved()) continue;
            ProviderLogging.log.connectorWithoutDownstream(component);
        }
        return true;
    }

    private void detectCycles() throws CycleException {
        for (Wiring.Component component : this.resolved) {
            HashSet<Wiring.Component> traces = new HashSet<Wiring.Component>();
            this.detectCycles(traces, component);
        }
    }

    private void detectCycles(Set<Wiring.Component> traces, Wiring.Component component) throws CycleException {
        traces.add(component);
        for (Wiring.Component downstream : component.downstreams()) {
            if (traces.contains(downstream)) {
                throw new CycleException(component, downstream);
            }
            traces.add(downstream);
            this.detectCycles(traces, downstream);
        }
    }
}

