/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.AbstractMediator;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.ProcessorMediator;
import io.smallrye.reactive.messaging.PublisherMediator;
import io.smallrye.reactive.messaging.StreamTransformerMediator;
import io.smallrye.reactive.messaging.SubscriberMediator;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class MediatorFactory {
    public AbstractMediator create(MediatorConfiguration configuration) {
        switch (configuration.shape()) {
            case PROCESSOR: {
                return new ProcessorMediator(configuration);
            }
            case SUBSCRIBER: {
                return new SubscriberMediator(configuration);
            }
            case PUBLISHER: {
                return new PublisherMediator(configuration);
            }
            case STREAM_TRANSFORMER: {
                return new StreamTransformerMediator(configuration);
            }
        }
        throw ProviderExceptions.ex.illegalArgumentForUnsupportedShape(configuration.shape(), configuration.methodAsString());
    }
}

