/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscriberWrapper<I, T>
implements Processor<T, T> {
    private final Subscriber<I> delegate;
    private final BiFunction<T, Throwable, CompletionStage<Void>> postAck;
    private final AtomicReference<Subscription> upstream = new AtomicReference();
    private final Function<T, I> mapper;

    public SubscriberWrapper(Subscriber<I> userSubscriber, Function<T, I> mapper, BiFunction<T, Throwable, CompletionStage<Void>> postAck) {
        this.delegate = Objects.requireNonNull(userSubscriber);
        this.mapper = Objects.requireNonNull(mapper);
        this.postAck = postAck;
    }

    public void subscribe(Subscriber<? super T> s) {
        s.onSubscribe(new Subscription(){

            public void request(long n) {
            }

            public void cancel() {
                Subscription subscription = (Subscription)SubscriberWrapper.this.upstream.getAndSet(Subscriptions.CANCELLED);
                if (subscription != null) {
                    subscription.cancel();
                }
            }
        });
    }

    public void onSubscribe(final Subscription s) {
        if (!this.upstream.compareAndSet(null, s)) {
            throw new IllegalStateException("We already received a subscription");
        }
        this.delegate.onSubscribe(new Subscription(){

            public void request(long n) {
                s.request(n);
            }

            public void cancel() {
                Subscription subscription = (Subscription)SubscriberWrapper.this.upstream.getAndSet(Subscriptions.CANCELLED);
                if (subscription != null) {
                    subscription.cancel();
                }
            }
        });
    }

    public void onNext(T item) {
        block3: {
            try {
                this.delegate.onNext(this.mapper.apply(item));
                if (this.postAck != null) {
                    this.postAck.apply(item, null);
                }
            }
            catch (Exception e) {
                if (this.postAck == null) break block3;
                this.postAck.apply(item, e);
            }
        }
    }

    public void onError(Throwable error) {
        this.delegate.onError(error);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }
}

