/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.i18n.ProviderMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@ApplicationScoped
public class InternalChannelRegistry
implements ChannelRegistry {
    private final Map<String, List<Publisher<? extends Message<?>>>> publishers = new HashMap();
    private final Map<String, List<Subscriber<? extends Message<?>>>> subscribers = new HashMap();
    private final Map<String, Boolean> outgoing = new HashMap<String, Boolean>();
    private final Map<String, Boolean> incoming = new HashMap<String, Boolean>();
    private final Map<String, Emitter<?>> emitters = new HashMap();
    private final Map<String, MutinyEmitter<?>> mutinyEmitters = new HashMap();

    public Publisher<? extends Message<?>> register(String name, Publisher<? extends Message<?>> stream, boolean broadcast) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(stream, ProviderMessages.msg.streamMustBeSet());
        this.register(this.publishers, name, stream);
        this.outgoing.put(name, broadcast);
        return stream;
    }

    public synchronized Subscriber<? extends Message<?>> register(String name, Subscriber<? extends Message<?>> subscriber, boolean merge) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(subscriber, ProviderMessages.msg.subscriberMustBeSet());
        this.register(this.subscribers, name, subscriber);
        this.incoming.put(name, merge);
        return subscriber;
    }

    public synchronized void register(String name, Emitter<?> emitter) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(emitter, ProviderMessages.msg.emitterMustBeSet());
        this.emitters.put(name, emitter);
    }

    public synchronized void register(String name, MutinyEmitter<?> emitter) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        Objects.requireNonNull(emitter, ProviderMessages.msg.emitterMustBeSet());
        this.mutinyEmitters.put(name, emitter);
    }

    public synchronized List<Publisher<? extends Message<?>>> getPublishers(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.publishers.getOrDefault(name, Collections.emptyList());
    }

    public synchronized Emitter<?> getEmitter(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.emitters.get(name);
    }

    public synchronized MutinyEmitter<?> getMutinyEmitter(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.mutinyEmitters.get(name);
    }

    public synchronized List<Subscriber<? extends Message<?>>> getSubscribers(String name) {
        Objects.requireNonNull(name, ProviderMessages.msg.nameMustBeSet());
        return this.subscribers.getOrDefault(name, Collections.emptyList());
    }

    private <T> void register(Map<String, List<T>> multimap, String name, T item) {
        List list = multimap.computeIfAbsent(name, key -> new ArrayList());
        list.add(item);
    }

    public synchronized Set<String> getIncomingNames() {
        return new HashSet<String>(this.publishers.keySet());
    }

    public synchronized Set<String> getOutgoingNames() {
        return new HashSet<String>(this.subscribers.keySet());
    }

    public synchronized Set<String> getEmitterNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.emitters.keySet());
        set.addAll(this.mutinyEmitters.keySet());
        return set;
    }

    public Map<String, Boolean> getIncomingChannels() {
        return this.outgoing;
    }

    public Map<String, Boolean> getOutgoingChannels() {
        return this.incoming;
    }
}

