/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.wiring;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.AbstractMediator;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.extension.ChannelConfiguration;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.extension.EmitterImpl;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import io.smallrye.reactive.messaging.extension.MutinyEmitterImpl;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.wiring.Graph;
import io.smallrye.reactive.messaging.wiring.TooManyDownstreamCandidatesException;
import io.smallrye.reactive.messaging.wiring.TooManyUpstreamCandidatesException;
import io.smallrye.reactive.messaging.wiring.UnsatisfiedBroadcastException;
import io.smallrye.reactive.messaging.wiring.WiringException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@ApplicationScoped
public class Wiring {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    @Inject
    @ConfigProperty(name="mp.messaging.emitter.default-buffer-size", defaultValue="128")
    int defaultBufferSize;
    @Inject
    @ConfigProperty(name="smallrye.messaging.emitter.default-buffer-size", defaultValue="128")
    @Deprecated
    int defaultBufferSizeLegacy;
    @Inject
    MediatorManager manager;
    private final List<Component> components = new ArrayList<Component>();
    private Graph graph;
    private boolean strictMode;

    public void prepare(boolean strictMode, ChannelRegistry registry, List<EmitterConfiguration> emitters, List<ChannelConfiguration> channels, List<MediatorConfiguration> mediators) {
        this.strictMode = strictMode;
        for (MediatorConfiguration mediatorConfiguration : mediators) {
            if (mediatorConfiguration.getOutgoing() != null && !mediatorConfiguration.getIncoming().isEmpty()) {
                this.components.add(new ProcessorMediatorComponent(this.manager, mediatorConfiguration));
                continue;
            }
            if (mediatorConfiguration.getOutgoing() != null) {
                this.components.add(new PublisherMediatorComponent(this.manager, mediatorConfiguration));
                continue;
            }
            this.components.add(new SubscriberMediatorComponent(this.manager, mediatorConfiguration));
        }
        for (ChannelConfiguration channelConfiguration : channels) {
            this.components.add(new InjectedChannelComponent(channelConfiguration, strictMode));
        }
        for (EmitterConfiguration emitterConfiguration : emitters) {
            this.components.add(new EmitterComponent(emitterConfiguration, this.defaultBufferSize, this.defaultBufferSizeLegacy));
        }
        for (Map.Entry entry : registry.getIncomingChannels().entrySet()) {
            this.components.add(new InboundConnectorComponent((String)entry.getKey(), (Boolean)entry.getValue()));
        }
        for (Map.Entry entry : registry.getOutgoingChannels().entrySet()) {
            this.components.add(new OutgoingConnectorComponent((String)entry.getKey(), (Boolean)entry.getValue()));
        }
    }

    public Graph resolve() {
        ProviderLogging.log.startGraphResolution(this.components.size());
        long begin = System.nanoTime();
        LinkedHashSet<Component> resolved = new LinkedHashSet<Component>();
        LinkedHashSet<ConsumingComponent> unresolved = new LinkedHashSet<ConsumingComponent>();
        for (Component component : this.components) {
            if (component.isUpstreamResolved()) {
                resolved.add(component);
                continue;
            }
            unresolved.add((ConsumingComponent)component);
        }
        boolean doneOrStale = false;
        while (!doneOrStale) {
            ArrayList<ConsumingComponent> resolvedDuringThisTurn = new ArrayList<ConsumingComponent>();
            for (ConsumingComponent consumingComponent : unresolved) {
                List<String> incomings = consumingComponent.incomings();
                for (String string : incomings) {
                    List<Component> matches = this.getMatchesFor(string, resolved);
                    if (matches.isEmpty()) continue;
                    matches.forEach(m -> this.bind(consumingComponent, (Component)m));
                    if (!consumingComponent.isUpstreamResolved()) continue;
                    resolvedDuringThisTurn.add(consumingComponent);
                }
            }
            resolved.addAll(resolvedDuringThisTurn);
            resolvedDuringThisTurn.forEach(unresolved::remove);
            doneOrStale = resolvedDuringThisTurn.isEmpty() || unresolved.isEmpty();
            for (Component component : resolved) {
                if (!(component instanceof ConsumingComponent)) continue;
                ConsumingComponent cc = (ConsumingComponent)component;
                List<String> incomings = cc.incomings();
                for (String incoming2 : incomings) {
                    List<Component> matches = this.getMatchesFor(incoming2, resolved);
                    for (Component match : matches) {
                        this.bind(cc, match);
                    }
                }
            }
        }
        ArrayList<ConsumingComponent> newlyResolved = new ArrayList<ConsumingComponent>();
        for (ConsumingComponent consumingComponent : unresolved) {
            for (String incoming : consumingComponent.incomings()) {
                List<Component> list = this.getMatchesFor(incoming, unresolved);
                if (list.isEmpty()) continue;
                newlyResolved.add(consumingComponent);
                list.forEach(m -> this.bind(c, (Component)m));
            }
        }
        if (!newlyResolved.isEmpty()) {
            newlyResolved.forEach(unresolved::remove);
            resolved.addAll(newlyResolved);
        }
        this.graph = new Graph(this.strictMode, resolved, unresolved);
        long duration = System.nanoTime() - begin;
        ProviderLogging.log.completedGraphResolution(duration);
        return this.graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    private void bind(ConsumingComponent consumer, Component provider) {
        consumer.connectUpstream(provider);
        provider.connectDownstream(consumer);
    }

    private List<Component> getMatchesFor(String incoming, Set<? extends Component> candidates) {
        ArrayList<Component> matches = new ArrayList<Component>();
        for (Component component : candidates) {
            Optional<String> outgoing = component.outgoing();
            if (!outgoing.isPresent() || !outgoing.get().equalsIgnoreCase(incoming)) continue;
            matches.add(component);
        }
        return matches;
    }

    static class ProcessorMediatorComponent
    extends MediatorComponent
    implements ConsumingComponent,
    PublishingComponent {
        private final Set<Component> upstreams = new LinkedHashSet<Component>();
        private final Set<Component> downstreams = new LinkedHashSet<Component>();

        protected ProcessorMediatorComponent(MediatorManager manager, MediatorConfiguration configuration) {
            super(manager, configuration);
        }

        @Override
        public Set<Component> upstreams() {
            return this.upstreams;
        }

        @Override
        public List<String> incomings() {
            return this.configuration.getIncoming();
        }

        @Override
        public boolean merge() {
            return this.configuration.getMerge() != null;
        }

        @Override
        public Optional<String> outgoing() {
            return Optional.of(this.configuration.getOutgoing());
        }

        @Override
        public Set<Component> downstreams() {
            return this.downstreams;
        }

        @Override
        public boolean broadcast() {
            return this.configuration.getBroadcast();
        }

        @Override
        public int getRequiredNumberOfSubscribers() {
            return this.configuration.getNumberOfSubscriberBeforeConnecting();
        }

        private boolean hasAllUpstreams() {
            for (String incoming : this.incomings()) {
                if (!this.upstreams().stream().noneMatch(c -> incoming.equals(c.outgoing().orElse(null)))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isUpstreamResolved() {
            return this.hasAllUpstreams();
        }

        public String toString() {
            return "ProcessingMethod{method:'" + this.configuration.methodAsString() + "', incoming:'" + String.join((CharSequence)",", this.configuration.getIncoming()) + "', outgoing:'" + this.getOutgoingChannel() + "'}";
        }

        @Override
        public void materialize(ChannelRegistry registry) {
            AbstractMediator mediator = this.manager.createMediator(this.configuration);
            boolean concat = this.configuration.getMerge() == Merge.Mode.CONCAT;
            boolean one = this.configuration.getMerge() == Merge.Mode.ONE;
            ArrayList publishers = new ArrayList();
            for (String channel : this.configuration.getIncoming()) {
                publishers.addAll(registry.getPublishers(channel));
            }
            Multi aggregates = publishers.size() == 1 ? Multi.createFrom().publisher((Publisher)publishers.get(0)) : (concat ? Multi.createBy().concatenating().streams((Iterable)publishers.stream().map(p -> p).collect(Collectors.toList())) : (one ? Multi.createFrom().publisher((Publisher)publishers.get(0)) : Multi.createBy().merging().streams((Iterable)publishers.stream().map(p -> p).collect(Collectors.toList()))));
            mediator.connectToUpstream(aggregates);
            registry.register(this.getOutgoingChannel(), mediator.getStream(), this.merge());
        }

        @Override
        public void validate() throws WiringException {
            for (String incoming : this.incomings()) {
                List<Component> components = this.downstreams().stream().filter(c -> incoming.equals(c.outgoing().orElse(null))).collect(Collectors.toList());
                if (components.size() <= 1 || this.merge()) continue;
                throw new TooManyUpstreamCandidatesException(this, incoming, components);
            }
            if (!this.merge() && this.upstreams.size() != this.incomings().size()) {
                throw new TooManyUpstreamCandidatesException(this);
            }
            if (!this.broadcast() && this.downstreams().size() > 1) {
                throw new TooManyDownstreamCandidatesException(this);
            }
            if (this.broadcast() && this.getRequiredNumberOfSubscribers() != 0 && this.getRequiredNumberOfSubscribers() != this.downstreams.size()) {
                throw new UnsatisfiedBroadcastException(this);
            }
        }
    }

    static class SubscriberMediatorComponent
    extends MediatorComponent
    implements ConsumingComponent,
    NoDownstreamComponent {
        private final Set<Component> upstreams = new LinkedHashSet<Component>();

        protected SubscriberMediatorComponent(MediatorManager manager, MediatorConfiguration configuration) {
            super(manager, configuration);
        }

        @Override
        public Set<Component> upstreams() {
            return this.upstreams;
        }

        @Override
        public List<String> incomings() {
            return this.configuration.getIncoming();
        }

        @Override
        public boolean merge() {
            return this.configuration.getMerge() != null;
        }

        @Override
        public void materialize(ChannelRegistry registry) {
            AbstractMediator mediator = this.manager.createMediator(this.configuration);
            boolean concat = this.configuration.getMerge() == Merge.Mode.CONCAT;
            boolean one = this.configuration.getMerge() == Merge.Mode.ONE;
            ArrayList publishers = new ArrayList();
            for (String channel : this.configuration.getIncoming()) {
                publishers.addAll(registry.getPublishers(channel));
            }
            Multi aggregates = publishers.size() == 1 ? Multi.createFrom().publisher((Publisher)publishers.get(0)) : (concat ? Multi.createBy().concatenating().streams((Iterable)publishers.stream().map(p -> p).collect(Collectors.toList())) : (one ? Multi.createFrom().publisher((Publisher)publishers.get(0)) : Multi.createBy().merging().streams((Iterable)publishers.stream().map(p -> p).collect(Collectors.toList()))));
            mediator.connectToUpstream(aggregates);
            Subscriber<Message<?>> subscriber = mediator.getComputedSubscriber();
            this.incomings().forEach(s -> registry.register(s, subscriber, this.merge()));
            mediator.run();
        }

        public String toString() {
            return "SubscriberMethod{method:'" + this.configuration.methodAsString() + "', incoming:'" + String.join((CharSequence)",", this.configuration.getIncoming()) + "'}";
        }

        private boolean hasAllUpstreams() {
            for (String incoming : this.incomings()) {
                if (!this.upstreams().stream().noneMatch(c -> incoming.equals(c.outgoing().orElse(null)))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isUpstreamResolved() {
            return this.hasAllUpstreams();
        }

        @Override
        public void validate() throws WiringException {
            for (String incoming : this.incomings()) {
                List<Component> components = this.downstreams().stream().filter(c -> incoming.equals(c.outgoing().orElse(null))).collect(Collectors.toList());
                if (components.size() <= 1 || this.merge()) continue;
                throw new TooManyUpstreamCandidatesException(this, incoming, components);
            }
            if (!this.merge() && this.upstreams.size() != this.incomings().size()) {
                throw new TooManyUpstreamCandidatesException(this);
            }
        }
    }

    static class PublisherMediatorComponent
    extends MediatorComponent
    implements PublishingComponent,
    NoUpstreamComponent {
        private final Set<Component> downstreams = new LinkedHashSet<Component>();

        protected PublisherMediatorComponent(MediatorManager manager, MediatorConfiguration configuration) {
            super(manager, configuration);
        }

        @Override
        public Optional<String> outgoing() {
            return Optional.of(this.configuration.getOutgoing());
        }

        @Override
        public Set<Component> downstreams() {
            return this.downstreams;
        }

        @Override
        public void materialize(ChannelRegistry registry) {
            AbstractMediator mediator = this.manager.createMediator(this.configuration);
            registry.register(this.configuration.getOutgoing(), mediator.getStream(), this.broadcast());
        }

        @Override
        public boolean broadcast() {
            return this.configuration.getBroadcast();
        }

        @Override
        public int getRequiredNumberOfSubscribers() {
            return this.configuration.getNumberOfSubscriberBeforeConnecting();
        }

        public String toString() {
            return "PublisherMethod{method:'" + this.configuration.methodAsString() + "', outgoing:'" + this.getOutgoingChannel() + "'}";
        }

        @Override
        public void validate() throws WiringException {
            if (!this.broadcast() && this.downstreams().size() > 1) {
                throw new TooManyDownstreamCandidatesException(this);
            }
            if (this.broadcast() && this.getRequiredNumberOfSubscribers() != 0 && this.getRequiredNumberOfSubscribers() != this.downstreams.size()) {
                throw new UnsatisfiedBroadcastException(this);
            }
        }
    }

    static abstract class MediatorComponent
    implements Component {
        final MediatorConfiguration configuration;
        final MediatorManager manager;

        protected MediatorComponent(MediatorManager manager, MediatorConfiguration configuration) {
            this.configuration = configuration;
            this.manager = manager;
        }
    }

    static class EmitterComponent
    implements PublishingComponent,
    NoUpstreamComponent {
        private final EmitterConfiguration configuration;
        private final Set<Component> downstreams = new LinkedHashSet<Component>();
        private final int defaultBufferSize;
        private final int defaultBufferSizeLegacy;

        public EmitterComponent(EmitterConfiguration configuration, int defaultBufferSize, int defaultBufferSizeLegacy) {
            this.configuration = configuration;
            this.defaultBufferSize = defaultBufferSize;
            this.defaultBufferSizeLegacy = defaultBufferSizeLegacy;
        }

        @Override
        public Optional<String> outgoing() {
            return Optional.of(this.configuration.name);
        }

        @Override
        public Set<Component> downstreams() {
            return this.downstreams;
        }

        @Override
        public boolean broadcast() {
            return this.configuration.broadcast;
        }

        @Override
        public int getRequiredNumberOfSubscribers() {
            return this.configuration.numberOfSubscriberBeforeConnecting;
        }

        public String toString() {
            return "Emitter{channel:'" + this.getOutgoingChannel() + "'}";
        }

        @Override
        public void materialize(ChannelRegistry registry) {
            Publisher publisher;
            int def = this.getDefaultBufferSize();
            if (this.configuration.isMutinyEmitter) {
                MutinyEmitterImpl mutinyEmitter = new MutinyEmitterImpl(this.configuration, def);
                publisher = mutinyEmitter.getPublisher();
                registry.register(this.configuration.name, mutinyEmitter);
            } else {
                EmitterImpl emitter = new EmitterImpl(this.configuration, def);
                publisher = emitter.getPublisher();
                registry.register(this.configuration.name, emitter);
            }
            registry.register(this.configuration.name, publisher, this.broadcast());
        }

        private int getDefaultBufferSize() {
            if (this.defaultBufferSize == 128 && this.defaultBufferSizeLegacy != 128) {
                return this.defaultBufferSizeLegacy;
            }
            return this.defaultBufferSize;
        }

        @Override
        public void validate() throws WiringException {
            if (!this.configuration.broadcast && this.downstreams().size() > 1) {
                throw new TooManyDownstreamCandidatesException(this);
            }
            if (this.broadcast() && this.getRequiredNumberOfSubscribers() != 0 && this.getRequiredNumberOfSubscribers() != this.downstreams.size()) {
                throw new UnsatisfiedBroadcastException(this);
            }
        }
    }

    static class InjectedChannelComponent
    implements ConsumingComponent,
    NoDownstreamComponent {
        private final String name;
        private final Set<Component> upstreams = new LinkedHashSet<Component>();
        private final boolean strict;

        public InjectedChannelComponent(ChannelConfiguration configuration, boolean strict) {
            this.name = configuration.channelName;
            this.strict = strict;
        }

        @Override
        public List<String> incomings() {
            return Collections.singletonList(this.name);
        }

        @Override
        public boolean merge() {
            return !this.strict;
        }

        @Override
        public Set<Component> upstreams() {
            return this.upstreams;
        }

        public String toString() {
            return "@Channel{channel:'" + this.name + "'}";
        }

        @Override
        public void materialize(ChannelRegistry registry) {
        }

        @Override
        public void validate() throws WiringException {
            if (this.strict && this.upstreams().size() > 1) {
                throw new TooManyUpstreamCandidatesException(this);
            }
        }
    }

    static class OutgoingConnectorComponent
    implements ConsumingComponent,
    NoDownstreamComponent {
        private final String name;
        private final Set<Component> upstreams = new LinkedHashSet<Component>();
        private final boolean merge;

        public OutgoingConnectorComponent(String name, boolean merge) {
            this.name = name;
            this.merge = merge;
        }

        @Override
        public List<String> incomings() {
            return Collections.singletonList(this.name);
        }

        @Override
        public boolean merge() {
            return this.merge;
        }

        @Override
        public void connectUpstream(Component upstream) {
            this.upstreams.add(upstream);
        }

        @Override
        public Set<Component> upstreams() {
            return this.upstreams;
        }

        public String toString() {
            return "OutgoingConnector{channel:'" + this.name + "', attribute:'mp.messaging.outgoing." + this.name + "'}";
        }

        @Override
        public void materialize(ChannelRegistry registry) {
            List publishers = registry.getPublishers(this.name);
            Multi merged = publishers.size() == 1 ? Multi.createFrom().publisher((Publisher)publishers.get(0)) : Multi.createBy().merging().streams((Iterable)publishers.stream().map(p -> p).collect(Collectors.toList()));
            Subscriber connector = (Subscriber)registry.getSubscribers(this.name).get(0);
            merged.subscribe().withSubscriber(connector);
        }

        @Override
        public void validate() throws WiringException {
            if (this.upstreams().size() > 1 && !this.merge) {
                throw new TooManyUpstreamCandidatesException(this);
            }
        }
    }

    static class InboundConnectorComponent
    implements PublishingComponent,
    NoUpstreamComponent {
        private final String name;
        private final boolean broadcast;
        private final Set<Component> downstreams = new LinkedHashSet<Component>();

        public InboundConnectorComponent(String name, boolean broadcast) {
            this.name = name;
            this.broadcast = broadcast;
        }

        @Override
        public Optional<String> outgoing() {
            return Optional.of(this.name);
        }

        @Override
        public Set<Component> downstreams() {
            return this.downstreams;
        }

        @Override
        public void materialize(ChannelRegistry registry) {
        }

        @Override
        public boolean broadcast() {
            return this.broadcast;
        }

        @Override
        public int getRequiredNumberOfSubscribers() {
            return 0;
        }

        public String toString() {
            return "IncomingConnector{channel:'" + this.name + "', attribute:'mp.messaging.incoming." + this.name + "'}";
        }

        @Override
        public void validate() throws WiringException {
            if (!this.broadcast && this.downstreams().size() > 1) {
                throw new TooManyDownstreamCandidatesException(this);
            }
        }
    }

    static interface NoDownstreamComponent
    extends Component {
        @Override
        default public boolean isDownstreamResolved() {
            return true;
        }
    }

    static interface NoUpstreamComponent
    extends Component {
        @Override
        default public boolean isUpstreamResolved() {
            return true;
        }
    }

    static interface ConsumingComponent
    extends Component {
        @Override
        default public boolean isUpstreamResolved() {
            return !this.upstreams().isEmpty();
        }

        default public void connectUpstream(Component upstream) {
            this.upstreams().add(upstream);
        }

        public boolean merge();
    }

    static interface PublishingComponent
    extends Component {
        public boolean broadcast();

        public int getRequiredNumberOfSubscribers();

        default public String getOutgoingChannel() {
            return this.outgoing().orElseThrow(() -> new IllegalStateException("Outgoing not configured for " + this));
        }

        @Override
        default public boolean isDownstreamResolved() {
            return !this.downstreams().isEmpty();
        }

        @Override
        default public void connectDownstream(Component downstream) {
            this.downstreams().add(downstream);
        }
    }

    public static interface Component {
        public void validate() throws WiringException;

        public boolean isUpstreamResolved();

        public boolean isDownstreamResolved();

        default public Optional<String> outgoing() {
            return Optional.empty();
        }

        default public List<String> incomings() {
            return Collections.emptyList();
        }

        default public Set<Component> downstreams() {
            return Collections.emptySet();
        }

        default public Set<Component> upstreams() {
            return Collections.emptySet();
        }

        default public void connectDownstream(Component downstream) {
            throw new UnsupportedOperationException("Downstream connection not expected for " + this);
        }

        public void materialize(ChannelRegistry var1);
    }
}

