/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.keyed.KeyValueExtractor;
import io.smallrye.reactive.messaging.keyed.KeyedMulti;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.helpers.DefaultKeyedMulti;
import io.smallrye.reactive.messaging.providers.helpers.DefaultKeyedMultiOfMessage;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.messaging.Message;

public class KeyMultiUtils {
    private KeyMultiUtils() {
    }

    public static Multi<KeyedMulti<?, ?>> convertToKeyedMulti(Multi<? extends Message<?>> multi, Instance<KeyValueExtractor> extractors, MediatorConfiguration configuration) {
        Type keyType = configuration.getKeyType();
        Type valueType = configuration.getValueType();
        if (keyType == null) {
            throw ProviderExceptions.ex.failedToExtractKeyType(configuration.methodAsString());
        }
        if (valueType == null) {
            throw ProviderExceptions.ex.failedToExtractValueType(configuration.methodAsString());
        }
        List<KeyValueExtractor> sortedExtractors = CDIUtils.getSortedInstances(extractors);
        if (configuration.getKeyed() == null) {
            AtomicReference reference = new AtomicReference();
            return multi.invoke(m -> {
                if (reference.get() == null) {
                    KeyValueExtractor found = KeyMultiUtils.findExtractor(m, keyType, valueType, sortedExtractors, configuration);
                    reference.compareAndSet(null, found);
                }
            }).group().by(m -> ((KeyValueExtractor)reference.get()).extractKey(m, keyType), m -> ((KeyValueExtractor)reference.get()).extractValue(m, valueType)).map(gm -> new DefaultKeyedMulti(gm.key(), gm));
        }
        KeyValueExtractor extractor = KeyMultiUtils.findExtractor(extractors, configuration.getKeyed());
        return multi.group().by(m -> extractor.extractKey(m, keyType), m -> extractor.extractValue(m, valueType)).map(gm -> new DefaultKeyedMulti(gm.key(), gm));
    }

    public static Multi<KeyedMulti<?, Message<?>>> convertToKeyedMultiMessage(Multi<? extends Message<?>> multi, Instance<KeyValueExtractor> extractors, MediatorConfiguration configuration) {
        Type keyType = configuration.getKeyType();
        Type valueType = configuration.getValueType();
        if (keyType == null) {
            throw ProviderExceptions.ex.failedToExtractKeyType(configuration.methodAsString());
        }
        if (valueType == null) {
            throw ProviderExceptions.ex.failedToExtractValueType(configuration.methodAsString());
        }
        List<KeyValueExtractor> sortedExtractors = CDIUtils.getSortedInstances(extractors);
        if (configuration.getKeyed() == null) {
            AtomicReference reference = new AtomicReference();
            return multi.invoke(m -> {
                if (reference.get() == null) {
                    KeyValueExtractor found = KeyMultiUtils.findExtractor(m, keyType, valueType, sortedExtractors, configuration);
                    reference.compareAndSet(null, found);
                }
            }).group().by(m -> ((KeyValueExtractor)reference.get()).extractKey(m, keyType), m -> m.withPayload(((KeyValueExtractor)reference.get()).extractValue(m, valueType))).map(gm -> new DefaultKeyedMultiOfMessage(gm.key(), gm));
        }
        KeyValueExtractor extractor = KeyMultiUtils.findExtractor(extractors, configuration.getKeyed());
        return multi.group().by(m -> extractor.extractKey(m, keyType), m -> m.withPayload(extractor.extractValue(m, valueType))).map(gm -> new DefaultKeyedMultiOfMessage(gm.key(), gm));
    }

    private static KeyValueExtractor findExtractor(Message<?> message, Type keyType, Type valueType, List<KeyValueExtractor> extractors, MediatorConfiguration configuration) {
        return extractors.stream().filter(ext -> ext.canExtract(message, keyType, valueType)).findAny().orElseThrow(() -> ProviderExceptions.ex.noMatchingKeyValueExtractor(configuration.methodAsString()));
    }

    private static KeyValueExtractor findExtractor(Instance<KeyValueExtractor> extractors, Class<? extends KeyValueExtractor> clazz) {
        return (KeyValueExtractor)extractors.select(clazz, new Annotation[0]).get();
    }
}

