/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import io.smallrye.reactive.messaging.ClientCustomizer;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import jakarta.enterprise.inject.Instance;
import org.eclipse.microprofile.config.Config;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static <T> T customize(Config channelConfig, Instance<ClientCustomizer<T>> customizers, T config) {
        Object current = config;
        String channel = (String)channelConfig.getValue("channel-name", String.class);
        for (ClientCustomizer<T> customizer : CDIUtils.getSortedInstances(customizers)) {
            Object applied = customizer.customize(channel, channelConfig, current);
            if (applied == null) {
                ProviderLogging.log.infof("Skipping config customizer %s to channel %s", customizer.getClass().getName(), channel);
                continue;
            }
            current = applied;
        }
        return current;
    }
}

