/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.impl;

import io.smallrye.reactive.messaging.providers.impl.ConnectorConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;

public class OverrideConnectorConfig
extends ConnectorConfig {
    private final String nestedChannel;
    private final Map<String, Function<OverrideConnectorConfig, Object>> overrides;

    public OverrideConnectorConfig(String prefix, Config overall, String connector, String channel, Map<String, Function<OverrideConnectorConfig, Object>> overrides) {
        this(prefix, overall, connector, channel, null, overrides);
    }

    public OverrideConnectorConfig(String prefix, Config overall, String connector, String channel, String nestedChannel) {
        this(prefix, overall, connector, channel, nestedChannel, new HashMap<String, Function<OverrideConnectorConfig, Object>>());
    }

    public OverrideConnectorConfig(String prefix, Config overall, String connector, String channel, String nestedChannel, Map<String, Function<OverrideConnectorConfig, Object>> overrides) {
        super(prefix, overall, connector, channel);
        this.nestedChannel = nestedChannel;
        this.overrides = overrides;
    }

    protected String nestedChannelKey(String keyName) {
        return this.nestedChannel == null ? keyName : this.nestedChannel + "." + keyName;
    }

    public <T> Optional<T> getOriginalValue(String propertyName, Class<T> propertyType) {
        return super.getOptionalValue(propertyName, propertyType);
    }

    @Override
    public <T> T getValue(String propertyName, Class<T> propertyType) {
        Object o;
        Optional<T> maybeResult;
        if (this.nestedChannel != null && (maybeResult = this.getOptionalValueFromSuper(this.nestedChannelKey(propertyName), propertyType)).isPresent()) {
            return maybeResult.get();
        }
        Function<OverrideConnectorConfig, Object> function = this.overrides.get(propertyName);
        if (function != null && (o = function.apply(this)) != null) {
            if (propertyType.isInstance(o)) {
                return (T)o;
            }
            if (o instanceof String) {
                return this.convert((String)o, propertyType);
            }
        }
        return this.getValueFromSuper(propertyName, propertyType);
    }

    @Override
    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        Object o;
        Optional<T> maybe;
        if (this.nestedChannel != null && (maybe = this.getOptionalValueFromSuper(this.nestedChannelKey(propertyName), propertyType)).isPresent()) {
            return maybe;
        }
        Function<OverrideConnectorConfig, Object> function = this.overrides.get(propertyName);
        if (function != null && (o = function.apply(this)) != null) {
            if (propertyType.isInstance(o)) {
                return Optional.of(o);
            }
            if (o instanceof String) {
                return this.convertOptional((String)o, propertyType);
            }
            return Optional.empty();
        }
        return this.getOptionalValueFromSuper(propertyName, propertyType);
    }

    @Override
    public Iterable<String> getPropertyNames() {
        String prefix = this.channelPrefix;
        String nestedPrefix = this.channelPrefix + this.nestedChannel + ".";
        String prefixAlpha = this.toAlpha(prefix);
        String nestedPrefixAlpha = this.toAlpha(nestedPrefix);
        String prefixAlphaUpper = prefixAlpha.toUpperCase();
        String nestedPrefixAlphaUpper = nestedPrefixAlpha.toUpperCase();
        String connectorPrefix = "mp.messaging.connector." + this.connector + ".";
        String connectorNestedPrefix = connectorPrefix + this.nestedChannel + ".";
        String connectorPrefixAlpha = this.toAlpha(connectorPrefix);
        String connectorNestedPrefixAlpha = this.toAlpha(connectorNestedPrefix);
        String connectorPrefixAlphaUpper = connectorPrefixAlpha.toUpperCase();
        String connectorNestedPrefixAlphaUpper = connectorNestedPrefixAlpha.toUpperCase();
        HashSet<String> names = new HashSet<String>();
        for (String name : this.overall.getPropertyNames()) {
            String computed;
            if (name.startsWith(connectorNestedPrefix)) {
                computed = name.substring(connectorNestedPrefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorNestedPrefixAlpha)) {
                computed = name.substring(connectorNestedPrefixAlpha.length());
                if (!this.nameExists(connectorNestedPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorNestedPrefixAlphaUpper)) {
                computed = name.substring(connectorNestedPrefixAlphaUpper.length());
                if (!this.nameExists(connectorNestedPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefix)) {
                computed = name.substring(connectorPrefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlpha)) {
                computed = name.substring(connectorPrefixAlpha.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlphaUpper)) {
                computed = name.substring(connectorPrefixAlphaUpper.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(nestedPrefix)) {
                computed = name.substring(nestedPrefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(nestedPrefixAlpha)) {
                computed = name.substring(nestedPrefixAlpha.length());
                if (!this.nameExists(nestedPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(nestedPrefixAlphaUpper)) {
                computed = name.substring(nestedPrefixAlphaUpper.length());
                if (!this.nameExists(nestedPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefix)) {
                computed = name.substring(prefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefixAlpha)) {
                computed = name.substring(prefixAlpha.length());
                if (!this.nameExists(prefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefixAlphaUpper)) {
                computed = name.substring(prefixAlphaUpper.length());
                if (!this.nameExists(prefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (!(this.overall instanceof ConnectorConfig)) continue;
            names.add(name);
        }
        names.add("channel-name");
        names.addAll(this.overrides.keySet());
        return names;
    }

    private <T> Optional<T> getOptionalValueFromSuper(String propertyName, Class<T> propertyType) {
        return this.overall instanceof ConnectorConfig ? this.overall.getOptionalValue(propertyName, propertyType) : super.getOptionalValue(propertyName, propertyType);
    }

    private <T> T getValueFromSuper(String propertyName, Class<T> propertyType) {
        return (T)(this.overall instanceof ConnectorConfig ? this.overall.getValue(propertyName, propertyType) : super.getValue(propertyName, propertyType));
    }
}

