/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorOutgoingConfiguration;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.eclipse.microprofile.config.Config;

@ApplicationScoped
public class ConfigResolver {
    public static final String DEFAULT_PULSAR_CLIENT = "default-pulsar-client";
    public static final String DEFAULT_PULSAR_CONSUMER = "default-pulsar-consumer";
    public static final String DEFAULT_PULSAR_PRODUCER = "default-pulsar-producer";
    public static final TypeReference<Map<String, Object>> OBJECT_MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private final Instance<Map<String, Object>> configurations;
    private final Instance<ClientConfigurationData> clientConfigurations;
    private final Instance<ConsumerConfigurationData<?>> consumerConfigurations;
    private final Instance<ProducerConfigurationData> producerConfigurations;
    private final ObjectMapper mapper;

    @Inject
    public ConfigResolver(@Any Instance<Map<String, Object>> configurations, @Any Instance<ClientConfigurationData> clientConfigurations, @Any Instance<ConsumerConfigurationData<?>> consumerConfigurations, @Any Instance<ProducerConfigurationData> producerConfigurations) {
        this.configurations = configurations;
        this.clientConfigurations = clientConfigurations;
        this.consumerConfigurations = consumerConfigurations;
        this.producerConfigurations = producerConfigurations;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, false);
        this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Map<String, Object> configToMap(Object loadedConfig) {
        if (loadedConfig == null) {
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>((Map)this.mapper.convertValue(loadedConfig, OBJECT_MAP_TYPE_REF));
    }

    public ClientConfigurationData getClientConf(PulsarConnectorCommonConfiguration cc) {
        Map defaultConfig = (Map)CDIUtils.getInstanceById(this.configurations, (String)DEFAULT_PULSAR_CLIENT, HashMap::new);
        Map channelConfig = (Map)CDIUtils.getInstanceById(this.configurations, (String)cc.getClientConfiguration().orElse(cc.getChannel()), HashMap::new);
        ClientConfigurationData conf = (ClientConfigurationData)CDIUtils.getInstanceById(this.clientConfigurations, (String)cc.getClientConfiguration().orElse(cc.getChannel()), ClientConfigurationData::new);
        Config config = cc.config();
        return this.mergeConfig(conf.clone(), this.mergeMap(defaultConfig, channelConfig), config);
    }

    public ConsumerConfigurationData<?> getConsumerConf(PulsarConnectorIncomingConfiguration ic) {
        Map defaultConfig = (Map)CDIUtils.getInstanceById(this.configurations, (String)DEFAULT_PULSAR_CONSUMER, HashMap::new);
        Map channelConfig = (Map)CDIUtils.getInstanceById(this.configurations, (String)ic.getConsumerConfiguration().orElse(ic.getChannel()), HashMap::new);
        ConsumerConfigurationData conf = (ConsumerConfigurationData)CDIUtils.getInstanceById(this.consumerConfigurations, (String)ic.getConsumerConfiguration().orElse(ic.getChannel()), ConsumerConfigurationData::new);
        Config incomingConfig = ic.config();
        return this.mergeConfig(conf.clone(), this.mergeMap(defaultConfig, channelConfig), incomingConfig);
    }

    public ProducerConfigurationData getProducerConf(PulsarConnectorOutgoingConfiguration oc) {
        Map defaultConfig = (Map)CDIUtils.getInstanceById(this.configurations, (String)DEFAULT_PULSAR_PRODUCER, HashMap::new);
        Map channelConfig = (Map)CDIUtils.getInstanceById(this.configurations, (String)oc.getProducerConfiguration().orElse(oc.getChannel()), HashMap::new);
        ProducerConfigurationData conf = (ProducerConfigurationData)CDIUtils.getInstanceById(this.producerConfigurations, (String)oc.getProducerConfiguration().orElse(oc.getChannel()), ProducerConfigurationData::new);
        Config outgoingConfig = oc.config();
        return this.mergeConfig(conf.clone(), this.mergeMap(defaultConfig, channelConfig), outgoingConfig);
    }

    private Map<String, Object> mergeMap(Map<String, Object> defaultConfig, Map<String, Object> channelConfig) {
        HashMap<String, Object> map = new HashMap<String, Object>(defaultConfig);
        map.putAll(channelConfig);
        return map;
    }

    private <T> T mergeConfig(T conf, Map<String, Object> mapConf, Config config) {
        try {
            Map map = ConfigResolver.asJsonObject(config, new HashMap<String, Object>(mapConf)).getMap();
            return (T)this.mapper.updateValue(conf, (Object)map);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonObject asJsonObject(Config config, Map<String, Object> confToOverride) {
        JsonObject json = new JsonObject(confToOverride);
        Iterable propertyNames = config.getPropertyNames();
        for (String originalKey : propertyNames) {
            ConfigResolver.extractConfigKey(config, json, originalKey, "");
        }
        return json;
    }

    private static void extractConfigKey(Config config, JsonObject json, String originalKey, String prefixToStrip) {
        Optional d2;
        String key = originalKey;
        if (key.contains("_") || ConfigResolver.allCaps(key)) {
            key = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, originalKey);
        }
        String jsonKey = key.substring(prefixToStrip.length());
        try {
            Optional i = config.getOptionalValue(key, Integer.class);
            if (!i.isPresent()) {
                i = config.getOptionalValue(originalKey, Integer.class);
            }
            if (i.isPresent() && i.get() instanceof Integer) {
                json.put(jsonKey, i.get());
                return;
            }
        }
        catch (ClassCastException | IllegalArgumentException i) {
            // empty catch block
        }
        try {
            d2 = config.getOptionalValue(key, Double.class);
            if (!d2.isPresent()) {
                d2 = config.getOptionalValue(originalKey, Double.class);
            }
            if (d2.isPresent() && d2.get() instanceof Double) {
                json.put(jsonKey, d2.get());
                return;
            }
        }
        catch (ClassCastException | IllegalArgumentException d2) {
            // empty catch block
        }
        try {
            String s = config.getOptionalValue(key, String.class).orElseGet(() -> config.getOptionalValue(originalKey, String.class).orElse(null));
            if (s != null) {
                String value = s.trim();
                if (value.equalsIgnoreCase("false")) {
                    json.put(jsonKey, (Object)false);
                } else if (value.equalsIgnoreCase("true")) {
                    json.put(jsonKey, (Object)true);
                } else {
                    json.put(jsonKey, (Object)value);
                }
                return;
            }
        }
        catch (ClassCastException s) {
            // empty catch block
        }
        try {
            d2 = config.getOptionalValue(key, Boolean.class);
            if (!d2.isPresent()) {
                d2 = config.getOptionalValue(originalKey, Boolean.class);
            }
            if (d2.isPresent()) {
                json.put(jsonKey, d2.get());
            }
        }
        catch (ClassCastException | IllegalArgumentException runtimeException) {
            // empty catch block
        }
    }

    private static boolean allCaps(String key) {
        return key.toUpperCase().equals(key);
    }
}

