/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class PulsarConnectorCommonConfiguration {
    protected final Config config;

    public PulsarConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public Optional<String> getClientConfiguration() {
        return this.config.getOptionalValue("client-configuration", String.class);
    }

    public String getServiceUrl() {
        return this.config.getOptionalValue("serviceUrl", String.class).orElse("pulsar://localhost:6650");
    }

    public Optional<String> getTopic() {
        return this.config.getOptionalValue("topic", String.class);
    }

    public Optional<String> getSchema() {
        return this.config.getOptionalValue("schema", String.class);
    }

    public Boolean getHealthEnabled() {
        return this.config.getOptionalValue("health-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getTracingEnabled() {
        return this.config.getOptionalValue("tracing-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public void validate() {
    }
}

