/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.fault;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarFailureHandler;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessage;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.function.BiConsumer;
import org.apache.pulsar.client.api.Consumer;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class PulsarNack
implements PulsarFailureHandler {
    public static final String STRATEGY_NAME = "nack";
    private final Consumer<?> consumer;

    public PulsarNack(Consumer<?> consumer) {
        this.consumer = consumer;
    }

    @Override
    public Uni<Void> handle(PulsarIncomingMessage<?> message, Throwable reason, Metadata metadata) {
        this.consumer.negativeAcknowledge(message.getMessageId());
        return Uni.createFrom().voidItem().emitOn(arg_0 -> message.runOnMessageContext(arg_0));
    }

    @ApplicationScoped
    @Identifier(value="nack")
    public static class Factory
    implements PulsarFailureHandler.Factory {
        @Override
        public PulsarFailureHandler create(Consumer<?> consumer, PulsarConnectorIncomingConfiguration config, BiConsumer<Throwable, Boolean> reportFailure) {
            return new PulsarNack(consumer);
        }
    }
}

