package io.smallrye.reactive.messaging.pulsar.i18n;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class PulsarLogging_$logger extends DelegatingBasicLogger implements PulsarLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = PulsarLogging_$logger.class.getName();
    public PulsarLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToCloseConsumer(final Throwable t) {
        super.log.logf(FQCN, WARN, t, unableToCloseConsumer$str());
    }
    protected String unableToCloseConsumer$str() {
        return "SRMSG19000: Unable to close Pulsar consumer";
    }
    @Override
    public final void unableToCloseProducer(final Throwable t) {
        super.log.logf(FQCN, WARN, t, unableToCloseProducer$str());
    }
    protected String unableToCloseProducer$str() {
        return "SRMSG19001: Unable to close Pulsar producer";
    }
    @Override
    public final void unableToCloseClient(final Throwable t) {
        super.log.logf(FQCN, WARN, t, unableToCloseClient$str());
    }
    protected String unableToCloseClient$str() {
        return "SRMSG19002: Unable to close Pulsar client";
    }
    @Override
    public final void unableToAcknowledgeMessage(final Throwable t) {
        super.log.logf(FQCN, WARN, t, unableToAcknowledgeMessage$str());
    }
    protected String unableToAcknowledgeMessage$str() {
        return "SRMSG19003: Unable to acknowledge message";
    }
    @Override
    public final void unableToDispatch(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToDispatch$str());
    }
    protected String unableToDispatch$str() {
        return "SRMSG19004: Unable to dispatch message to Pulsar";
    }
    @Override
    public final void noSubscriptionName(final String randomName) {
        super.log.logf(FQCN, WARN, null, noSubscriptionName$str(), randomName);
    }
    protected String noSubscriptionName$str() {
        return "SRMSG19010: No `subscription-name` set in the configuration, generate a random name: %s";
    }
    @Override
    public final void createdConsumerWithConfig(final String channel, final String schema, final Object consumerConf) {
        super.log.logf(FQCN, INFO, null, createdConsumerWithConfig$str(), channel, schema, consumerConf);
    }
    protected String createdConsumerWithConfig$str() {
        return "SRMSG19011: Created consumer for channel `%s` with schema '%s' and configuration: %s";
    }
    @Override
    public final void createdProducerWithConfig(final String channel, final String schema, final Object producerConf) {
        super.log.logf(FQCN, INFO, null, createdProducerWithConfig$str(), channel, schema, producerConf);
    }
    protected String createdProducerWithConfig$str() {
        return "SRMSG19012: Created producer for channel `%s` with schema '%s' configuration: %s";
    }
    @Override
    public final void messageFailureFailStop(final String channel) {
        super.log.logf(FQCN, WARN, null, messageFailureFailStop$str(), channel);
    }
    protected String messageFailureFailStop$str() {
        return "SRMSG19013: Failed to process a message sent to channel `%s`, fail-stopping the processing";
    }
    @Override
    public final void messageFailureIgnored(final String channel, final String reason) {
        super.log.logf(FQCN, WARN, null, messageFailureIgnored$str(), channel, reason);
    }
    protected String messageFailureIgnored$str() {
        return "SRMSG19014: Failed to process a message sent to channel `%s`, proceeding with ack, ignored failure is: %s.";
    }
    @Override
    public final void messageFailureFullCause(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, messageFailureFullCause$str());
    }
    protected String messageFailureFullCause$str() {
        return "SRMSG19015: The full cause is";
    }
    @Override
    public final void failedToReceiveFromConsumer(final String channel, final Throwable t) {
        super.log.logf(FQCN, INFO, t, failedToReceiveFromConsumer$str(), channel);
    }
    protected String failedToReceiveFromConsumer$str() {
        return "SRMSG19016: The consumer for channel `%s` failed to receive message";
    }
    @Override
    public final void consumerReachedEndOfTopic(final String channel) {
        super.log.logf(FQCN, INFO, null, consumerReachedEndOfTopic$str(), channel);
    }
    protected String consumerReachedEndOfTopic$str() {
        return "SRMSG19017: The consumer for channel `%s` reached end of topic";
    }
    @Override
    public final void clientClosed(final String channel, final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, clientClosed$str(), channel);
    }
    protected String clientClosed$str() {
        return "SRMSG19018: The client for channel `%s` has been closed";
    }
    @Override
    public final void unableToParseRedeliveryBackoff(final String redeliveryBackoff, final String channel) {
        super.log.logf(FQCN, WARN, null, unableToParseRedeliveryBackoff$str(), redeliveryBackoff, channel);
    }
    protected String unableToParseRedeliveryBackoff$str() {
        return "SRMSG19019: Unable to parse redelivery backoff config `%s` for channel `%s`";
    }
    @Override
    public final void createdClientWithConfig(final Object clientConf) {
        super.log.logf(FQCN, INFO, null, createdClientWithConfig$str(), clientConf);
    }
    protected String createdClientWithConfig$str() {
        return "SRMSG19020: Created client with configuration: %s";
    }
    @Override
    public final void primitiveSchemaNotFound(final String schemaName, final String channel) {
        super.log.logf(FQCN, DEBUG, null, primitiveSchemaNotFound$str(), schemaName, channel);
    }
    protected String primitiveSchemaNotFound$str() {
        return "SRMSG19021: No schema type %s found for the channel %s";
    }
    @Override
    public final void schemaProviderNotFound(final String schemaProviderId, final String channel, final String defaultSchema) {
        super.log.logf(FQCN, WARN, null, schemaProviderNotFound$str(), schemaProviderId, channel, defaultSchema);
    }
    protected String schemaProviderNotFound$str() {
        return "SRMSG19022: The schema provider not found with id '%s', for channel '%s' falling back to default schema %s";
    }
    @Override
    public final void messageFailureContinued(final String channel, final String reason) {
        super.log.logf(FQCN, WARN, null, messageFailureContinued$str(), channel, reason);
    }
    protected String messageFailureContinued$str() {
        return "SRMSG19023: Failed to process a message sent to channel `%s`, proceeding without ack/nack, failure is: %s.";
    }
    @Override
    public final void messageFailureNacked(final String channel, final String reason) {
        super.log.logf(FQCN, WARN, null, messageFailureNacked$str(), channel, reason);
    }
    protected String messageFailureNacked$str() {
        return "SRMSG19024: Failed to process a message sent to channel `%s`, proceeding with nack, failure is: %s.";
    }
    @Override
    public final void messageFailureDelayed(final String channel, final long delaySeconds, final String reason) {
        super.log.logf(FQCN, WARN, null, messageFailureDelayed$str(), channel, delaySeconds, reason);
    }
    protected String messageFailureDelayed$str() {
        return "SRMSG19025: Failed to process a message sent to channel `%s`, tryign to reconsume in %s seconds, failure is: %s.";
    }
}
