/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.helpers.Validation;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.pulsar.i18n.PulsarLogging;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

@ApplicationScoped
public class SchemaResolver {
    private final Instance<Schema<?>> schemas;

    @Inject
    public SchemaResolver(@Any Instance<Schema<?>> schemas) {
        this.schemas = schemas;
    }

    public Schema<?> getSchema(PulsarConnectorIncomingConfiguration ic) {
        return this.getSchema(ic, Schema.AUTO_CONSUME());
    }

    public Schema<?> getSchema(PulsarConnectorOutgoingConfiguration oc) {
        return this.getSchema(oc, Schema.AUTO_PRODUCE_BYTES());
    }

    private Schema<?> getSchema(PulsarConnectorCommonConfiguration configuration, Schema<?> defaultSchema) {
        Optional<String> schemaName = configuration.getSchema();
        if (schemaName.isPresent()) {
            try {
                return Schema.getSchema((SchemaInfo)SchemaInfo.builder().type(SchemaType.valueOf((String)schemaName.get())).build());
            }
            catch (Exception ignored) {
                PulsarLogging.log.primitiveSchemaNotFound(schemaName.get(), configuration.getChannel());
            }
        }
        String schemaIdentifier = schemaName.orElse(configuration.getChannel());
        return (Schema)CDIUtils.getInstanceById(this.schemas, (String)schemaIdentifier, () -> {
            PulsarLogging.log.schemaProviderNotFound(schemaIdentifier, configuration.getChannel(), defaultSchema.toString());
            return defaultSchema;
        });
    }

    public static String getSchemaName(Schema<?> schema) {
        SchemaInfo schemaInfo = schema.getSchemaInfo();
        if (schemaInfo == null || Validation.isBlank((String)schemaInfo.getName())) {
            return schema.getClass().getSimpleName();
        }
        return schemaInfo.getName();
    }
}

