/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.fault;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarFailureHandler;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessage;
import io.smallrye.reactive.messaging.pulsar.i18n.PulsarLogging;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.function.BiConsumer;
import org.apache.pulsar.client.api.Consumer;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class PulsarFailStop
implements PulsarFailureHandler {
    public static final String STRATEGY_NAME = "fail";
    private final String channel;
    private final BiConsumer<Throwable, Boolean> reportFailure;

    public PulsarFailStop(String channel, BiConsumer<Throwable, Boolean> reportFailure) {
        this.channel = channel;
        this.reportFailure = reportFailure;
    }

    @Override
    public Uni<Void> handle(PulsarIncomingMessage<?> message, Throwable reason, Metadata metadata) {
        PulsarLogging.log.messageFailureFailStop(this.channel);
        this.reportFailure.accept(reason, true);
        return Uni.createFrom().failure(reason).emitOn(arg_0 -> message.runOnMessageContext(arg_0));
    }

    @ApplicationScoped
    @Identifier(value="fail")
    public static class Factory
    implements PulsarFailureHandler.Factory {
        @Override
        public PulsarFailStop create(Consumer<?> consumer, PulsarConnectorIncomingConfiguration config, BiConsumer<Throwable, Boolean> reportFailure) {
            return new PulsarFailStop(config.getChannel(), reportFailure);
        }
    }
}

