/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.smallrye.reactive.messaging.pulsar.tracing.PulsarAttributesExtractor;
import io.smallrye.reactive.messaging.pulsar.tracing.PulsarTrace;
import io.smallrye.reactive.messaging.pulsar.tracing.PulsarTraceTextMapGetter;
import io.smallrye.reactive.messaging.pulsar.tracing.PulsarTraceTextMapSetter;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.inject.Instance;
import org.eclipse.microprofile.reactive.messaging.Message;

public class PulsarOpenTelemetryInstrumenter {
    private final Instrumenter<PulsarTrace, Void> instrumenter;

    public PulsarOpenTelemetryInstrumenter(Instrumenter<PulsarTrace, Void> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static PulsarOpenTelemetryInstrumenter createForSource(Instance<OpenTelemetry> openTelemetryInstance) {
        return PulsarOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), true);
    }

    public static PulsarOpenTelemetryInstrumenter createForSink(Instance<OpenTelemetry> openTelemetryInstance) {
        return PulsarOpenTelemetryInstrumenter.create(TracingUtils.getOpenTelemetry(openTelemetryInstance), false);
    }

    private static PulsarOpenTelemetryInstrumenter create(OpenTelemetry openTelemetry, boolean source) {
        MessageOperation messageOperation = source ? MessageOperation.RECEIVE : MessageOperation.PUBLISH;
        PulsarAttributesExtractor attributesExtractor = new PulsarAttributesExtractor();
        MessagingAttributesGetter<PulsarTrace, Void> messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.reactive.messaging", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation));
        builder.addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)messageOperation)).addAttributesExtractor((AttributesExtractor)attributesExtractor);
        if (source) {
            return new PulsarOpenTelemetryInstrumenter((Instrumenter<PulsarTrace, Void>)builder.buildConsumerInstrumenter((TextMapGetter)PulsarTraceTextMapGetter.INSTANCE));
        }
        return new PulsarOpenTelemetryInstrumenter((Instrumenter<PulsarTrace, Void>)builder.buildProducerInstrumenter((TextMapSetter)PulsarTraceTextMapSetter.INSTANCE));
    }

    public void traceOutgoing(Message<?> message, PulsarTrace trace) {
        TracingUtils.traceOutgoing(this.instrumenter, message, (Object)trace);
    }

    public void traceIncoming(Message<?> message, PulsarTrace trace) {
        TracingUtils.traceIncoming(this.instrumenter, message, (Object)trace);
    }
}

