/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.smallrye.reactive.messaging.pulsar.PulsarOutgoingMessage;
import io.smallrye.reactive.messaging.pulsar.PulsarOutgoingMessageMetadata;
import java.util.Map;
import org.eclipse.microprofile.reactive.messaging.Message;

public interface PulsarMessage<T>
extends ContextAwareMessage<T> {
    public static <T> PulsarOutgoingMessage<T> from(Message<T> message) {
        return PulsarOutgoingMessage.from(message);
    }

    public static <T> PulsarMessage<T> of(T payload) {
        return new PulsarOutgoingMessage<T>(payload, null, null);
    }

    public static <T> PulsarMessage<T> of(T payload, String key) {
        return new PulsarOutgoingMessage<T>(payload, null, null, PulsarOutgoingMessageMetadata.builder().withKey(key).build());
    }

    public static <T> PulsarMessage<T> of(T payload, byte[] keyBytes) {
        return new PulsarOutgoingMessage<T>(payload, null, null, PulsarOutgoingMessageMetadata.builder().withKeyBytes(keyBytes).build());
    }

    public static <T> PulsarMessage<T> of(T payload, PulsarOutgoingMessageMetadata metadata) {
        return new PulsarOutgoingMessage<T>(payload, null, null, metadata);
    }

    public String getKey();

    public byte[] getKeyBytes();

    public boolean hasKey();

    public byte[] getOrderingKey();

    public Map<String, String> getProperties();

    public long getEventTime();

    public long getSequenceId();
}

