/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessage;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessageMetadata;
import io.smallrye.reactive.messaging.pulsar.i18n.PulsarMessages;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;

public class PulsarIncomingBatchMessageMetadata {
    private final Messages<?> delegate;
    private final List<PulsarIncomingMessage<?>> batchedMessages;

    public PulsarIncomingBatchMessageMetadata(Messages<?> messages) {
        this(messages, Collections.emptyList());
    }

    public <T> PulsarIncomingBatchMessageMetadata(Messages<T> messages, List<PulsarIncomingMessage<?>> batchedMessages) {
        this.delegate = Objects.requireNonNull(messages, PulsarMessages.msg.isRequired("messages"));
        this.batchedMessages = batchedMessages;
    }

    public <T> Messages<T> getMessages() {
        return this.delegate;
    }

    public List<PulsarIncomingMessage<?>> getIncomingMessages() {
        return this.batchedMessages;
    }

    public <M> M getMetadataForMessage(Message<?> msg, Class<M> metadata) {
        for (org.eclipse.microprofile.reactive.messaging.Message message : this.batchedMessages) {
            if (!((PulsarIncomingMessageMetadata)message.getMetadata().get(PulsarIncomingMessageMetadata.class).orElseThrow()).getMessage().equals(msg)) continue;
            return message.getMetadata(metadata).orElse(null);
        }
        return null;
    }
}

