/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.converters;

import io.smallrye.reactive.messaging.keyed.KeyValueExtractor;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessageMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class KeyValueFromPulsarMessageExtractor
implements KeyValueExtractor {
    public boolean canExtract(Message<?> message, Type keyType, Type valueType) {
        Optional metadata = message.getMetadata(PulsarIncomingMessageMetadata.class);
        return metadata.filter(incomingMetadata -> incomingMetadata.hasKey() && TypeUtils.isAssignable((Type)keyType, incomingMetadata.getKey().getClass()) && TypeUtils.isAssignable((Type)valueType, message.getPayload().getClass())).isPresent();
    }

    public Object extractKey(Message<?> message, Type keyType) {
        return message.getMetadata(PulsarIncomingMessageMetadata.class).map(PulsarIncomingMessageMetadata::getKey).orElseThrow();
    }

    public Object extractValue(Message<?> message, Type valueType) {
        return message.getPayload();
    }
}

