/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.fault;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarFailureHandler;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessage;
import io.smallrye.reactive.messaging.pulsar.i18n.PulsarLogging;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.function.BiConsumer;
import org.apache.pulsar.client.api.Consumer;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class PulsarIgnore
implements PulsarFailureHandler {
    public static final String STRATEGY_NAME = "ignore";
    private final String channel;

    public PulsarIgnore(String channel) {
        this.channel = channel;
    }

    @Override
    public Uni<Void> handle(PulsarIncomingMessage<?> message, Throwable reason, Metadata metadata) {
        PulsarLogging.log.messageFailureIgnored(this.channel, reason.getMessage());
        PulsarLogging.log.messageFailureFullCause(reason);
        return Uni.createFrom().completionStage(message.ack()).emitOn(arg_0 -> message.runOnMessageContext(arg_0));
    }

    @ApplicationScoped
    @Identifier(value="ignore")
    public static class Factory
    implements PulsarFailureHandler.Factory {
        @Override
        public PulsarFailureHandler create(Consumer<?> consumer, PulsarConnectorIncomingConfiguration config, BiConsumer<Throwable, Boolean> reportFailure) {
            return new PulsarIgnore(config.getChannel());
        }
    }
}

