/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.i18n;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRMSG", length=5)
public interface PulsarLogging
extends BasicLogger {
    public static final PulsarLogging log = (PulsarLogging)Logger.getMessageLogger(PulsarLogging.class, (String)"io.smallrye.reactive.messaging.pulsar");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19000, value="Unable to close Pulsar consumer")
    public void unableToCloseConsumer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19001, value="Unable to close Pulsar producer")
    public void unableToCloseProducer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19002, value="Unable to close Pulsar client")
    public void unableToCloseClient(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19003, value="Unable to acknowledge message")
    public void unableToAcknowledgeMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=19004, value="Unable to dispatch message to Pulsar")
    public void unableToDispatch(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19010, value="No `subscription-name` set in the configuration, generate a random name: %s")
    public void noSubscriptionName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19011, value="Created consumer for channel `%s` with schema '%s' and configuration: %s")
    public void createdConsumerWithConfig(String var1, String var2, Object var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19012, value="Created producer for channel `%s` with schema '%s' configuration: %s")
    public void createdProducerWithConfig(String var1, String var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19013, value="Failed to process a message sent to channel `%s`, fail-stopping the processing")
    public void messageFailureFailStop(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19014, value="Failed to process a message sent to channel `%s`, proceeding with ack, ignored failure is: %s.")
    public void messageFailureIgnored(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=19015, value="The full cause is")
    public void messageFailureFullCause(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19016, value="The consumer for channel `%s` failed to receive message")
    public void failedToReceiveFromConsumer(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19017, value="The consumer for channel `%s` reached end of topic")
    public void consumerReachedEndOfTopic(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=19018, value="The client for channel `%s` has been closed")
    public void clientClosed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19019, value="Unable to parse redelivery backoff config `%s` for channel `%s`")
    public void unableToParseRedeliveryBackoff(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19020, value="Created client with configuration: %s")
    public void createdClientWithConfig(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=19021, value="No schema type %s found for the channel %s")
    public void primitiveSchemaNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19022, value="The schema provider not found with id '%s', for channel '%s' falling back to default schema %s")
    public void schemaProviderNotFound(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19023, value="Failed to process a message sent to channel `%s`, proceeding without ack/nack, failure is: %s.")
    public void messageFailureContinued(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19024, value="Failed to process a message sent to channel `%s`, proceeding with nack, failure is: %s.")
    public void messageFailureNacked(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19025, value="Failed to process a message sent to channel `%s`, tryign to reconsume in %s seconds, failure is: %s.")
    public void messageFailureDelayed(String var1, long var2, String var4);
}

