/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import io.smallrye.reactive.messaging.providers.MetadataInjectableMessage;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.smallrye.reactive.messaging.pulsar.PulsarAckHandler;
import io.smallrye.reactive.messaging.pulsar.PulsarFailureHandler;
import io.smallrye.reactive.messaging.pulsar.PulsarIdMessage;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessageMetadata;
import io.smallrye.reactive.messaging.pulsar.PulsarMessage;
import io.smallrye.reactive.messaging.pulsar.i18n.PulsarMessages;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class PulsarIncomingMessage<T>
implements PulsarMessage<T>,
PulsarIdMessage<T>,
MetadataInjectableMessage<T> {
    private final Message<T> delegate;
    private Metadata metadata;
    private final PulsarAckHandler ackHandler;
    private final PulsarFailureHandler nackHandler;

    public PulsarIncomingMessage(Message<T> message, PulsarAckHandler ackHandler, PulsarFailureHandler nackHandler) {
        this.delegate = Objects.requireNonNull(message, PulsarMessages.msg.isRequired("message"));
        this.ackHandler = Objects.requireNonNull(ackHandler, PulsarMessages.msg.isRequired("ack"));
        this.nackHandler = Objects.requireNonNull(nackHandler, PulsarMessages.msg.isRequired("nack"));
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{new PulsarIncomingMessageMetadata(message)});
    }

    @Override
    public MessageId getMessageId() {
        return this.delegate.getMessageId();
    }

    public T getPayload() {
        return (T)this.delegate.getValue();
    }

    @Override
    public String getKey() {
        return this.delegate.getKey();
    }

    @Override
    public byte[] getKeyBytes() {
        return this.delegate.getKeyBytes();
    }

    @Override
    public boolean hasKey() {
        return this.delegate.hasKey();
    }

    @Override
    public byte[] getOrderingKey() {
        return this.delegate.getOrderingKey();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public long getEventTime() {
        return this.delegate.getEventTime();
    }

    @Override
    public long getSequenceId() {
        return this.delegate.getSequenceId();
    }

    public long getPublishTime() {
        return this.delegate.getPublishTime();
    }

    public Message<T> unwrap() {
        return this.delegate;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public CompletionStage<Void> ack() {
        return this.ackHandler.handle(this).subscribeAsCompletionStage();
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return this.nackHandler.handle(this, reason, metadata).subscribeAsCompletionStage();
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((PulsarIncomingMessage)this).nack(arg_0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarIncomingMessage that = (PulsarIncomingMessage)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public synchronized void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }
}

