/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQExceptions;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.rabbitmq.RabbitMQClient;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class ConnectionHolder {
    private final RabbitMQClient client;
    private final RabbitMQConnectorCommonConfiguration configuration;
    private final AtomicReference<CurrentConnection> holder = new AtomicReference();
    private final Vertx vertx;

    public ConnectionHolder(RabbitMQClient client, RabbitMQConnectorCommonConfiguration configuration, Vertx vertx) {
        this.client = client;
        this.configuration = configuration;
        this.vertx = vertx;
    }

    public static CompletionStage<Void> runOnContext(Context context, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Vertx.currentContext() == context) {
            runnable.run();
            future.complete(null);
        } else {
            context.runOnContext(() -> {
                runnable.run();
                future.complete(null);
            });
        }
        return future;
    }

    public static CompletionStage<Void> runOnContextAndReportFailure(Context context, Throwable reason, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Vertx.currentContext() == context) {
            runnable.run();
            future.completeExceptionally(reason);
        } else {
            context.runOnContext(() -> {
                runnable.run();
                future.completeExceptionally(reason);
            });
        }
        return future;
    }

    public Context getContext() {
        CurrentConnection connection = this.holder.get();
        if (connection != null) {
            return connection.context;
        }
        return null;
    }

    public Uni<Void> getAck(long deliveryTag) {
        return this.client.basicAck(deliveryTag, false);
    }

    public Function<Throwable, CompletionStage<Void>> getNack(long deliveryTag, boolean requeue) {
        return t -> this.client.basicNack(deliveryTag, false, requeue).subscribeAsCompletionStage();
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public synchronized void onFailure(Consumer<Throwable> callback) {
    }

    public Uni<RabbitMQClient> getOrEstablishConnection() {
        return Uni.createFrom().item(() -> {
            CurrentConnection connection = this.holder.get();
            if (connection != null && connection.connection != null && connection.connection.isConnected()) {
                return connection.connection;
            }
            return null;
        }).onItem().ifNull().switchTo(() -> {
            CurrentConnection reference = this.holder.get();
            if (reference != null && reference.connection != null && reference.connection.isConnected()) {
                RabbitMQClient connection = reference.connection;
                return Uni.createFrom().item((Object)connection);
            }
            RabbitMQLogging.log.establishingConnection(this.configuration.getChannel());
            return this.client.start().onSubscribe().invoke(() -> RabbitMQLogging.log.connectionEstablished(this.configuration.getChannel())).onItem().transform(ignored -> {
                this.holder.set(new CurrentConnection(this.client, Vertx.currentContext()));
                if (!this.client.isConnected() || this.holder.get() == null) {
                    this.holder.set(null);
                    throw RabbitMQExceptions.ex.illegalStateConnectionDisconnected();
                }
                return this.client;
            }).onFailure().invoke(ex -> RabbitMQLogging.log.unableToConnectToBroker((Throwable)ex)).onFailure().invoke(t -> {
                this.holder.set(null);
                RabbitMQLogging.log.unableToRecoverFromConnectionDisruption((Throwable)t);
            });
        });
    }

    private static class CurrentConnection {
        final RabbitMQClient connection;
        final Context context;

        private CurrentConnection(RabbitMQClient connection, Context context) {
            this.connection = connection;
            this.context = context;
        }
    }
}

