/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import com.rabbitmq.client.impl.DefaultCredentialsRefreshService;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnector;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQExceptions;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.core.net.JksOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.rabbitmq.RabbitMQClient;
import io.vertx.rabbitmq.RabbitMQOptions;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;

public class RabbitMQClientHelper {
    private static final double CREDENTIALS_PROVIDER_REFRESH_DELAY_RATIO = 0.8;
    private static final Duration CREDENTIALS_PROVIDER_APPROACH_EXPIRE_TIME = Duration.ofSeconds(1L);

    private RabbitMQClientHelper() {
    }

    static RabbitMQClient createClient(RabbitMQConnector connector, RabbitMQConnectorCommonConfiguration config, Instance<RabbitMQOptions> optionsInstances, Instance<CredentialsProvider> credentialsProviderInstances) {
        Optional<String> clientOptionsName = config.getClientOptionsName();
        Vertx vertx = connector.getVertx();
        RabbitMQClient client = clientOptionsName.isPresent() ? RabbitMQClientHelper.createClientFromClientOptionsBean(vertx, optionsInstances, clientOptionsName.get()) : RabbitMQClientHelper.getClient(vertx, config, credentialsProviderInstances);
        connector.addClient(client);
        return client;
    }

    static RabbitMQClient createClientFromClientOptionsBean(Vertx vertx, Instance<RabbitMQOptions> options, String optionsBeanName) {
        if ((options = options.select(new Annotation[]{Identifier.Literal.of((String)optionsBeanName)})).isUnsatisfied() && !(options = options.select(new Annotation[]{NamedLiteral.of((String)optionsBeanName)})).isUnsatisfied()) {
            ProviderLogging.log.deprecatedNamed();
        }
        if (!options.isResolvable()) {
            throw RabbitMQExceptions.ex.illegalStateFindingBean(RabbitMQOptions.class.getName(), optionsBeanName);
        }
        RabbitMQLogging.log.createClientFromBean(optionsBeanName);
        return RabbitMQClient.create((Vertx)vertx, (RabbitMQOptions)((RabbitMQOptions)options.get()));
    }

    static RabbitMQClient getClient(Vertx vertx, RabbitMQConnectorCommonConfiguration config, Instance<CredentialsProvider> credentialsProviders) {
        try {
            String host = config.getHost();
            int port = config.getPort();
            RabbitMQLogging.log.brokerConfigured(host, port, config.getChannel());
            RabbitMQOptions options = new RabbitMQOptions().setHost(host).setPort(port).setSsl(config.getSsl().booleanValue()).setTrustAll(config.getTrustAll().booleanValue()).setAutomaticRecoveryEnabled(config.getAutomaticRecoveryEnabled().booleanValue()).setAutomaticRecoveryOnInitialConnection(config.getAutomaticRecoveryOnInitialConnection().booleanValue()).setReconnectAttempts(config.getReconnectAttempts().intValue()).setReconnectInterval((long)config.getReconnectInterval().intValue()).setConnectionTimeout(config.getConnectionTimeout().intValue()).setHandshakeTimeout(config.getHandshakeTimeout().intValue()).setIncludeProperties(config.getIncludeProperties().booleanValue()).setNetworkRecoveryInterval((long)config.getNetworkRecoveryInterval().intValue()).setRequestedChannelMax(config.getRequestedChannelMax().intValue()).setRequestedHeartbeat(config.getRequestedHeartbeat().intValue()).setUseNio(config.getUseNio().booleanValue()).setVirtualHost(config.getVirtualHost());
            Optional<String> trustStorePath = config.getTrustStorePath();
            if (trustStorePath.isPresent()) {
                JksOptions jks = new JksOptions();
                jks.setPath(trustStorePath.get());
                config.getTrustStorePassword().ifPresent(arg_0 -> ((JksOptions)jks).setPassword(arg_0));
                options.setTrustStoreOptions(jks);
            }
            if (config.getCredentialsProviderName().isPresent()) {
                String credentialsProviderName = config.getCredentialsProviderName().get();
                if ((credentialsProviders = credentialsProviders.select(new Annotation[]{Identifier.Literal.of((String)credentialsProviderName)})).isUnsatisfied() && !(credentialsProviders = credentialsProviders.select(new Annotation[]{NamedLiteral.of((String)credentialsProviderName)})).isUnsatisfied()) {
                    ProviderLogging.log.deprecatedNamed();
                }
                if (!credentialsProviders.isResolvable()) {
                    throw RabbitMQExceptions.ex.illegalStateFindingBean(CredentialsProvider.class.getName(), credentialsProviderName);
                }
                CredentialsProvider credentialsProvider = (CredentialsProvider)credentialsProviders.get();
                options.setCredentialsProvider(credentialsProvider);
                options.setCredentialsRefreshService((CredentialsRefreshService)new DefaultCredentialsRefreshService((ScheduledExecutorService)vertx.nettyEventLoopGroup(), DefaultCredentialsRefreshService.ratioRefreshDelayStrategy((double)0.8), DefaultCredentialsRefreshService.fixedTimeApproachingExpirationStrategy((Duration)CREDENTIALS_PROVIDER_APPROACH_EXPIRE_TIME)));
            } else {
                String username = config.getUsername().orElse("guest");
                String password = config.getPassword().orElse("guest");
                options.setUser(username);
                options.setPassword(password);
            }
            return RabbitMQClient.create((Vertx)vertx, (RabbitMQOptions)options);
        }
        catch (Exception e) {
            RabbitMQLogging.log.unableToCreateClient(e);
            throw RabbitMQExceptions.ex.illegalStateUnableToCreateClient(e);
        }
    }
}

