/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.tracing;

import com.rabbitmq.client.Envelope;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMessage;
import io.smallrye.reactive.messaging.rabbitmq.OutgoingRabbitMQMetadata;
import io.smallrye.reactive.messaging.rabbitmq.tracing.HeadersMapExtractAdapter;
import io.smallrye.reactive.messaging.rabbitmq.tracing.HeadersMapInjectAdapter;
import io.vertx.rabbitmq.RabbitMQMessage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Message;

public abstract class TracingUtils {
    private static final String SYSTEM_RABBITMQ = "rabbitmq";
    private static final String DESTINATION_EXCHANGE = "exchange";
    private static final String DESTINATION_QUEUE = "queue";
    private static Tracer tracer;

    public static void initialise() {
        tracer = GlobalOpenTelemetry.getTracerProvider().get("io.smallrye.reactive.messaging.rabbitmq");
    }

    private TracingUtils() {
    }

    public static TracingMetadata getTracingMetaData(RabbitMQMessage msg) {
        TracingMetadata tracingMetadata = TracingMetadata.empty();
        if (msg.properties().getHeaders() != null) {
            Context context = GlobalOpenTelemetry.getPropagators().getTextMapPropagator().extract(Context.root(), (Object)msg.properties().getHeaders(), (TextMapGetter)HeadersMapExtractAdapter.GETTER);
            tracingMetadata = TracingMetadata.withPrevious((Context)context);
        }
        return tracingMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Message<T> addIncomingTrace(IncomingRabbitMQMessage<T> msg, String queue, List<String> attributeHeaders) {
        TracingMetadata tracingMetadata = TracingMetadata.fromMessage(msg).orElse(TracingMetadata.empty());
        Envelope envelope = msg.getRabbitMQMessage().envelope();
        SpanBuilder spanBuilder = tracer.spanBuilder(envelope.getExchange() + " receive").setSpanKind(SpanKind.CONSUMER);
        Context parentSpanContext = tracingMetadata.getPreviousContext();
        if (parentSpanContext != null) {
            spanBuilder.setParent(parentSpanContext);
        } else {
            spanBuilder.setNoParent();
        }
        Span span = spanBuilder.startSpan();
        Map<String, Object> headerValues = msg.getHeaders().entrySet().stream().filter(e -> attributeHeaders.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        try {
            TracingUtils.setIncomingSpanAttributes(span, queue, envelope.getRoutingKey(), headerValues);
            span.makeCurrent();
            msg.injectTracingMetadata(tracingMetadata.withSpan(span));
        }
        finally {
            span.end();
        }
        return msg;
    }

    private static void setIncomingSpanAttributes(Span span, String queue, String routingKey, Map<String, Object> attributeHeaders) {
        span.setAttribute(SemanticAttributes.MESSAGING_RABBITMQ_ROUTING_KEY, (Object)routingKey);
        span.setAttribute(SemanticAttributes.MESSAGING_SYSTEM, (Object)SYSTEM_RABBITMQ);
        span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION, (Object)queue);
        span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION_KIND, (Object)DESTINATION_QUEUE);
        TracingUtils.setHeaderSpanAttributes(span, attributeHeaders);
    }

    private static void setOutgoingSpanAttributes(Span span, String exchange, String routingKey, Map<String, Object> attributeHeaders) {
        span.setAttribute(SemanticAttributes.MESSAGING_RABBITMQ_ROUTING_KEY, (Object)routingKey);
        span.setAttribute(SemanticAttributes.MESSAGING_SYSTEM, (Object)SYSTEM_RABBITMQ);
        span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION, (Object)exchange);
        span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION_KIND, (Object)DESTINATION_EXCHANGE);
        TracingUtils.setHeaderSpanAttributes(span, attributeHeaders);
    }

    private static void setHeaderSpanAttributes(Span span, Map<String, Object> attributeHeaders) {
        attributeHeaders.forEach((header, value) -> {
            if (value instanceof Long) {
                span.setAttribute(header, ((Long)value).longValue());
            } else if (value instanceof String) {
                span.setAttribute(header, (String)value);
            } else if (value instanceof Boolean) {
                span.setAttribute(header, ((Boolean)value).booleanValue());
            } else if (value instanceof Double) {
                span.setAttribute(header, ((Double)value).doubleValue());
            }
        });
    }

    public static void createOutgoingTrace(Message<?> message, Map<String, Object> headers, String exchange, String routingKey, List<String> attributeHeaders) {
        TracingMetadata tracingMetadata = TracingMetadata.fromMessage(message).orElse(null);
        SpanBuilder spanBuilder = tracer.spanBuilder(exchange + " send").setSpanKind(SpanKind.PRODUCER);
        if (tracingMetadata != null) {
            Context parentSpanContext = tracingMetadata.getPreviousContext();
            if (parentSpanContext != null) {
                spanBuilder.setParent(parentSpanContext);
            } else {
                spanBuilder.setNoParent();
            }
        } else {
            spanBuilder.setNoParent();
        }
        Span span = spanBuilder.startSpan();
        Context sendingContext = Context.current().with((ImplicitContextKeyed)span);
        Map<String, Object> headerValues = message.getMetadata(OutgoingRabbitMQMetadata.class).map(md -> md.getHeaders().entrySet().stream().filter(e -> attributeHeaders.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(Collections.emptyMap());
        TracingUtils.setOutgoingSpanAttributes(span, exchange, routingKey, headerValues);
        GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(sendingContext, headers, (TextMapSetter)HeadersMapInjectAdapter.SETTER);
        span.end();
    }
}

