/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.smallrye.reactive.messaging.rabbitmq.ConnectionHolder;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMetadata;
import io.smallrye.reactive.messaging.rabbitmq.ack.RabbitMQAckHandler;
import io.smallrye.reactive.messaging.rabbitmq.fault.RabbitMQFailureHandler;
import io.smallrye.reactive.messaging.rabbitmq.tracing.TracingUtils;
import io.vertx.core.buffer.Buffer;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.rabbitmq.RabbitMQMessage;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class IncomingRabbitMQMessage<T>
implements ContextAwareMessage<T> {
    protected final io.vertx.rabbitmq.RabbitMQMessage message;
    protected Metadata metadata;
    protected final IncomingRabbitMQMetadata rabbitMQMetadata;
    private final ConnectionHolder holder;
    private final Context context;
    private final long deliveryTag;
    protected final RabbitMQFailureHandler onNack;
    protected final RabbitMQAckHandler onAck;

    IncomingRabbitMQMessage(RabbitMQMessage delegate, ConnectionHolder holder, boolean isTracingEnabled, RabbitMQFailureHandler onNack, RabbitMQAckHandler onAck) {
        this(delegate.getDelegate(), holder, isTracingEnabled, onNack, onAck);
    }

    IncomingRabbitMQMessage(io.vertx.rabbitmq.RabbitMQMessage msg, ConnectionHolder holder, boolean isTracingEnabled, RabbitMQFailureHandler onNack, RabbitMQAckHandler onAck) {
        this.message = msg;
        this.deliveryTag = msg.envelope().getDeliveryTag();
        this.holder = holder;
        this.context = holder.getContext();
        this.rabbitMQMetadata = new IncomingRabbitMQMetadata(this.message);
        this.onNack = onNack;
        this.onAck = onAck;
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{this.rabbitMQMetadata});
        if (isTracingEnabled) {
            this.metadata = this.metadata.with((Object)TracingUtils.getTracingMetaData(msg));
        }
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((IncomingRabbitMQMessage)this).nack(arg_0);
    }

    public CompletionStage<Void> ack() {
        return this.onAck.handle(this, this.context);
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return this.onNack.handle(this, this.context, reason);
    }

    public void acknowledgeMessage() {
        this.holder.getAck(this.deliveryTag).subscribeAsCompletionStage();
    }

    public void rejectMessage(Throwable reason) {
        this.holder.getNack(this.deliveryTag, false).apply(reason);
    }

    public T getPayload() {
        return (T)this.convertPayload(this.message);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private Object convertPayload(io.vertx.rabbitmq.RabbitMQMessage msg) {
        String contentType = msg.properties().getContentType();
        String contentEncoding = msg.properties().getContentEncoding();
        Buffer body = msg.body();
        if (contentEncoding == null) {
            if (HttpHeaderValues.APPLICATION_JSON.toString().equalsIgnoreCase(contentType)) {
                return body.toJson();
            }
            if (HttpHeaderValues.TEXT_PLAIN.toString().equalsIgnoreCase(contentType)) {
                return body.toString();
            }
        }
        return body.getBytes();
    }

    public Optional<Integer> getPriority() {
        return this.rabbitMQMetadata.getPriority();
    }

    public Optional<String> getReplyTo() {
        return this.rabbitMQMetadata.getReplyTo();
    }

    public Optional<String> getUserId() {
        return this.rabbitMQMetadata.getUserId();
    }

    public Optional<String> getMessageId() {
        return this.rabbitMQMetadata.getId();
    }

    public Optional<ZonedDateTime> getCreationTime(ZoneId zoneId) {
        return this.rabbitMQMetadata.getCreationTime(zoneId);
    }

    public Optional<String> getContentType() {
        return this.rabbitMQMetadata.getContentType();
    }

    public Optional<String> getCorrelationId() {
        return this.rabbitMQMetadata.getCorrelationId();
    }

    public Optional<String> getContentEncoding() {
        return this.rabbitMQMetadata.getContentEncoding();
    }

    public Map<String, Object> getHeaders() {
        return this.rabbitMQMetadata.getHeaders();
    }

    public RabbitMQMessage getRabbitMQMessage() {
        return new RabbitMQMessage(this.message);
    }

    public synchronized void injectTracingMetadata(TracingMetadata tracingMetadata) {
        this.metadata = this.metadata.with((Object)tracingMetadata);
    }
}

