/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

public class OutgoingRabbitMQMetadata {
    private Integer priority;
    private String contentType;
    private String contentEncoding;
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private Integer deliveryMode;
    private String correlationId;
    private String replyTo;
    private String expiration;
    private String messageId;
    private ZonedDateTime timestamp;
    private String type;
    private String userId;
    private String appId;
    private String clusterId;
    private String routingKey;

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer priority;
        private String contentType;
        private String contentEncoding;
        private Map<String, Object> headers = new HashMap<String, Object>();
        private Integer deliveryMode;
        private String correlationId;
        private String replyTo;
        private String expiration;
        private String messageId;
        private ZonedDateTime timestamp;
        private String type;
        private String userId;
        private String appId;
        private String clusterId;
        private String routingKey;

        public Builder withHeader(String header, Object value) {
            this.headers.put(header, value);
            return this;
        }

        public Builder withHeaders(Map<String, Object> header) {
            this.headers.putAll(header);
            return this;
        }

        public Builder withAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder withContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder withClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withCorrelationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public Builder withDeliveryMode(Integer deliveryMode) {
            this.deliveryMode = deliveryMode;
            return this;
        }

        public Builder withExpiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public Builder withMessageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder withPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder withReplyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder withRoutingKey(String routingKey) {
            this.routingKey = routingKey;
            return this;
        }

        public Builder withTimestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public OutgoingRabbitMQMetadata build() {
            OutgoingRabbitMQMetadata metadata = new OutgoingRabbitMQMetadata();
            metadata.appId = this.appId;
            metadata.contentEncoding = this.contentEncoding;
            metadata.clusterId = this.clusterId;
            metadata.correlationId = this.correlationId;
            metadata.headers.putAll(this.headers);
            metadata.contentType = this.contentType;
            metadata.correlationId = this.correlationId;
            metadata.deliveryMode = this.deliveryMode;
            metadata.expiration = this.expiration;
            metadata.messageId = this.messageId;
            metadata.priority = this.priority;
            metadata.replyTo = this.replyTo;
            metadata.routingKey = this.routingKey;
            metadata.timestamp = this.timestamp;
            metadata.type = this.type;
            metadata.userId = this.userId;
            return metadata;
        }
    }
}

