/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQExceptions;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.rabbitmq.RabbitMQClient;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ConnectionHolder {
    private final RabbitMQClient client;
    private final AtomicReference<CurrentConnection> connectionHolder = new AtomicReference();
    private final Uni<RabbitMQClient> connector;
    private final Vertx vertx;

    public ConnectionHolder(RabbitMQClient client, RabbitMQConnectorCommonConfiguration configuration, Vertx vertx) {
        this.client = client;
        this.vertx = vertx;
        this.connector = Uni.createFrom().voidItem().onItem().transformToUni(unused -> {
            RabbitMQLogging.log.establishingConnection(configuration.getChannel());
            return client.start().onSubscription().invoke(() -> RabbitMQLogging.log.connectionEstablished(configuration.getChannel())).onItem().transform(ignored -> {
                this.connectionHolder.set(new CurrentConnection(client, Vertx.currentContext()));
                if (!client.isConnected() || this.connectionHolder.get() == null) {
                    this.connectionHolder.set(null);
                    throw RabbitMQExceptions.ex.illegalStateConnectionDisconnected();
                }
                return client;
            }).onFailure().invoke(RabbitMQLogging.log::unableToConnectToBroker).onFailure().invoke(t -> {
                this.connectionHolder.set(null);
                RabbitMQLogging.log.unableToRecoverFromConnectionDisruption((Throwable)t);
            });
        }).memoize().until(() -> {
            CurrentConnection connection = this.connectionHolder.get();
            if (connection == null) {
                return true;
            }
            return !connection.connection.isConnected();
        });
    }

    public static CompletionStage<Void> runOnContext(Context context, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Vertx.currentContext() == context) {
            runnable.run();
            future.complete(null);
        } else {
            context.runOnContext(() -> {
                runnable.run();
                future.complete(null);
            });
        }
        return future;
    }

    public static CompletionStage<Void> runOnContextAndReportFailure(Context context, Throwable reason, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Vertx.currentContext() == context) {
            runnable.run();
            future.completeExceptionally(reason);
        } else {
            context.runOnContext(() -> {
                runnable.run();
                future.completeExceptionally(reason);
            });
        }
        return future;
    }

    public Context getContext() {
        CurrentConnection connection = this.connectionHolder.get();
        if (connection != null) {
            return connection.context;
        }
        return null;
    }

    @CheckReturnValue
    public Uni<Void> getAck(long deliveryTag) {
        return this.client.basicAck(deliveryTag, false);
    }

    public Function<Throwable, CompletionStage<Void>> getNack(long deliveryTag, boolean requeue) {
        return t -> this.client.basicNack(deliveryTag, false, requeue).subscribeAsCompletionStage();
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    @CheckReturnValue
    public Uni<RabbitMQClient> getOrEstablishConnection() {
        return this.connector;
    }

    private static class CurrentConnection {
        final RabbitMQClient connection;
        final Context context;

        private CurrentConnection(RabbitMQClient connection, Context context) {
            this.connection = connection;
            this.context = context;
        }
    }
}

