/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.i18n;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;

@MessageLogger(projectCode="SRMSG", length=5)
public interface RabbitMQLogging
extends BasicLogger {
    public static final RabbitMQLogging log = (RabbitMQLogging)Logger.getMessageLogger(RabbitMQLogging.class, (String)"io.smallrye.reactive.messaging.rabbitmq");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17000, value="RabbitMQ Receiver listening address %s")
    public void receiverListeningAddress(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17001, value="RabbitMQ Receiver error")
    public void receiverError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17002, value="Unable to retrieve messages from RabbitMQ, retrying...")
    public void retrieveMessagesRetrying(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17003, value="Unable to retrieve messages from RabbitMQ, no more retry")
    public void retrieveMessagesNoMoreRetrying(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17006, value="Establishing connection with RabbitMQ broker for channel `%s`")
    public void establishingConnection(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17007, value="Connection with RabbitMQ broker established for channel `%s`")
    public void connectionEstablished(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17008, value="Unable to connect to the broker, retry will be attempted")
    public void unableToConnectToBroker(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17009, value="Unable to recover from RabbitMQ connection disruption")
    public void unableToRecoverFromConnectionDisruption(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17010, value="A message sent to channel `%s` has been nacked, ignoring the failure and marking the RabbitMQ message as accepted")
    public void nackedAcceptMessage(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17011, value="The full ignored failure is")
    public void fullIgnoredFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17012, value="A message sent to channel `%s` has been nacked, rejecting the RabbitMQ message and fail-stop")
    public void nackedFailMessage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17013, value="A message sent to channel `%s` has been nacked, ignoring the failure and marking the RabbitMQ message as rejected")
    public void nackedIgnoreMessage(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17018, value="Failure reported for channel `%s`, closing client")
    public void failureReported(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17021, value="Unable to serialize message on channel `%s`, message has been nacked")
    public void serializationFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17022, value="Sending a message to exchange `%s` with routing key %s")
    public void sendingMessageToExchange(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17023, value="Established exchange `%s`")
    public void exchangeEstablished(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17024, value="Unable to establish exchange `%s`")
    public void unableToEstablishExchange(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17025, value="Established queue `%s`")
    public void queueEstablished(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17026, value="Unable to bind queue '%s' to exchange '%s'")
    public void unableToEstablishBinding(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17027, value="Established binding of queue `%s` to exchange '%s' using routing key '%s'")
    public void bindingEstablished(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17028, value="Unable to establish queue `%s`")
    public void unableToEstablishQueue(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17029, value="Established dlx `%s`")
    public void dlxEstablished(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17030, value="Unable to establish dlx `%s`")
    public void unableToEstablishDlx(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17033, value="A message sent to channel `%s` has been ack'd")
    public void ackMessage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17034, value="A message sent to channel `%s` has not been explicitly ack'd as auto-ack is enabled")
    public void ackAutoMessage(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17035, value="Creating RabbitMQ client from bean named '%s'")
    public void createClientFromBean(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17036, value="RabbitMQ broker configured to %s:%d for channel %s")
    public void brokerConfigured(String var1, int var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17037, value="Unable to create client")
    public void unableToCreateClient(@Cause Throwable var1);

    @Once
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17038, value="No valid content_type set, failing back to byte[]. If that's wanted, set the content type to application/octet-stream with \"content-type-override\"")
    public void typeConversionFallback();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17039, value="Connection '%d' with RabbitMQ broker established for channel `%s`")
    public void connectionEstablished(int var1, String var2);
}

