package io.smallrye.reactive.messaging.rabbitmq.i18n;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class RabbitMQLogging_$logger extends DelegatingBasicLogger implements RabbitMQLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RabbitMQLogging_$logger.class.getName();
    public RabbitMQLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void receiverListeningAddress(final String address) {
        super.log.logf(FQCN, INFO, null, receiverListeningAddress$str(), address);
    }
    protected String receiverListeningAddress$str() {
        return "SRMSG17000: RabbitMQ Receiver listening address %s";
    }
    @Override
    public final void receiverError(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, receiverError$str());
    }
    protected String receiverError$str() {
        return "SRMSG17001: RabbitMQ Receiver error";
    }
    @Override
    public final void retrieveMessagesRetrying(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, retrieveMessagesRetrying$str());
    }
    protected String retrieveMessagesRetrying$str() {
        return "SRMSG17002: Unable to retrieve messages from RabbitMQ, retrying...";
    }
    @Override
    public final void retrieveMessagesNoMoreRetrying(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, retrieveMessagesNoMoreRetrying$str());
    }
    protected String retrieveMessagesNoMoreRetrying$str() {
        return "SRMSG17003: Unable to retrieve messages from RabbitMQ, no more retry";
    }
    @Override
    public final void establishingConnection(final String channel) {
        super.log.logf(FQCN, INFO, null, establishingConnection$str(), channel);
    }
    protected String establishingConnection$str() {
        return "SRMSG17006: Establishing connection with RabbitMQ broker for channel `%s`";
    }
    @Override
    public final void connectionEstablished(final String channel) {
        super.log.logf(FQCN, INFO, null, connectionEstablished1$str(), channel);
    }
    protected String connectionEstablished1$str() {
        return "SRMSG17007: Connection with RabbitMQ broker established for channel `%s`";
    }
    @Override
    public final void unableToConnectToBroker(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToConnectToBroker$str());
    }
    protected String unableToConnectToBroker$str() {
        return "SRMSG17008: Unable to connect to the broker, retry will be attempted";
    }
    @Override
    public final void unableToRecoverFromConnectionDisruption(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToRecoverFromConnectionDisruption$str());
    }
    protected String unableToRecoverFromConnectionDisruption$str() {
        return "SRMSG17009: Unable to recover from RabbitMQ connection disruption";
    }
    @Override
    public final void nackedAcceptMessage(final String channel) {
        super.log.logf(FQCN, WARN, null, nackedAcceptMessage$str(), channel);
    }
    protected String nackedAcceptMessage$str() {
        return "SRMSG17010: A message sent to channel `%s` has been nacked, ignoring the failure and marking the RabbitMQ message as accepted";
    }
    @Override
    public final void fullIgnoredFailure(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, fullIgnoredFailure$str());
    }
    protected String fullIgnoredFailure$str() {
        return "SRMSG17011: The full ignored failure is";
    }
    @Override
    public final void nackedFailMessage(final String channel) {
        super.log.logf(FQCN, ERROR, null, nackedFailMessage$str(), channel);
    }
    protected String nackedFailMessage$str() {
        return "SRMSG17012: A message sent to channel `%s` has been nacked, rejecting the RabbitMQ message and fail-stop";
    }
    @Override
    public final void nackedIgnoreMessage(final String channel) {
        super.log.logf(FQCN, WARN, null, nackedIgnoreMessage$str(), channel);
    }
    protected String nackedIgnoreMessage$str() {
        return "SRMSG17013: A message sent to channel `%s` has been nacked, ignoring the failure and marking the RabbitMQ message as rejected";
    }
    @Override
    public final void failureReported(final String channel, final Throwable reason) {
        super.log.logf(FQCN, ERROR, reason, failureReported$str(), channel);
    }
    protected String failureReported$str() {
        return "SRMSG17018: Failure reported for channel `%s`, closing client";
    }
    @Override
    public final void serializationFailure(final String channel, final Throwable reason) {
        super.log.logf(FQCN, ERROR, reason, serializationFailure$str(), channel);
    }
    protected String serializationFailure$str() {
        return "SRMSG17021: Unable to serialize message on channel `%s`, message has been nacked";
    }
    @Override
    public final void sendingMessageToExchange(final String exchange, final String routingKey) {
        super.log.logf(FQCN, DEBUG, null, sendingMessageToExchange$str(), exchange, routingKey);
    }
    protected String sendingMessageToExchange$str() {
        return "SRMSG17022: Sending a message to exchange `%s` with routing key %s";
    }
    @Override
    public final void exchangeEstablished(final String exchangeName) {
        super.log.logf(FQCN, DEBUG, null, exchangeEstablished$str(), exchangeName);
    }
    protected String exchangeEstablished$str() {
        return "SRMSG17023: Established exchange `%s`";
    }
    @Override
    public final void unableToEstablishExchange(final String exchangeName, final Throwable ex) {
        super.log.logf(FQCN, ERROR, ex, unableToEstablishExchange$str(), exchangeName);
    }
    protected String unableToEstablishExchange$str() {
        return "SRMSG17024: Unable to establish exchange `%s`";
    }
    @Override
    public final void queueEstablished(final String queueName) {
        super.log.logf(FQCN, DEBUG, null, queueEstablished$str(), queueName);
    }
    protected String queueEstablished$str() {
        return "SRMSG17025: Established queue `%s`";
    }
    @Override
    public final void unableToEstablishBinding(final String queueName, final String exchangeName, final Throwable ex) {
        super.log.logf(FQCN, ERROR, ex, unableToEstablishBinding$str(), queueName, exchangeName);
    }
    protected String unableToEstablishBinding$str() {
        return "SRMSG17026: Unable to bind queue '%s' to exchange '%s'";
    }
    @Override
    public final void bindingEstablished(final String queueName, final String exchangeName, final String routingKey) {
        super.log.logf(FQCN, DEBUG, null, bindingEstablished$str(), queueName, exchangeName, routingKey);
    }
    protected String bindingEstablished$str() {
        return "SRMSG17027: Established binding of queue `%s` to exchange '%s' using routing key '%s'";
    }
    @Override
    public final void unableToEstablishQueue(final String exchangeName, final Throwable ex) {
        super.log.logf(FQCN, ERROR, ex, unableToEstablishQueue$str(), exchangeName);
    }
    protected String unableToEstablishQueue$str() {
        return "SRMSG17028: Unable to establish queue `%s`";
    }
    @Override
    public final void dlxEstablished(final String deadLetterExchangeName) {
        super.log.logf(FQCN, DEBUG, null, dlxEstablished$str(), deadLetterExchangeName);
    }
    protected String dlxEstablished$str() {
        return "SRMSG17029: Established dlx `%s`";
    }
    @Override
    public final void unableToEstablishDlx(final String deadLetterExchangeName, final Throwable ex) {
        super.log.logf(FQCN, ERROR, ex, unableToEstablishDlx$str(), deadLetterExchangeName);
    }
    protected String unableToEstablishDlx$str() {
        return "SRMSG17030: Unable to establish dlx `%s`";
    }
    @Override
    public final void ackMessage(final String channel) {
        super.log.logf(FQCN, INFO, null, ackMessage$str(), channel);
    }
    protected String ackMessage$str() {
        return "SRMSG17033: A message sent to channel `%s` has been ack'd";
    }
    @Override
    public final void ackAutoMessage(final String channel) {
        super.log.logf(FQCN, INFO, null, ackAutoMessage$str(), channel);
    }
    protected String ackAutoMessage$str() {
        return "SRMSG17034: A message sent to channel `%s` has not been explicitly ack'd as auto-ack is enabled";
    }
    @Override
    public final void createClientFromBean(final String optionsBeanName) {
        super.log.logf(FQCN, DEBUG, null, createClientFromBean$str(), optionsBeanName);
    }
    protected String createClientFromBean$str() {
        return "SRMSG17035: Creating RabbitMQ client from bean named '%s'";
    }
    @Override
    public final void brokerConfigured(final String host, final int port, final String channel) {
        super.log.logf(FQCN, INFO, null, brokerConfigured$str(), host, port, channel);
    }
    protected String brokerConfigured$str() {
        return "SRMSG17036: RabbitMQ broker configured to %s:%d for channel %s";
    }
    @Override
    public final void unableToCreateClient(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToCreateClient$str());
    }
    protected String unableToCreateClient$str() {
        return "SRMSG17037: Unable to create client";
    }
    @Override
    public final void typeConversionFallback() {
        if (super.log.isEnabled(WARN) && typeConversionFallback_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, typeConversionFallback$str());
        }
    }
    protected String typeConversionFallback$str() {
        return "SRMSG17038: No valid content_type set, failing back to byte[]. If that's wanted, set the content type to application/octet-stream with \"content-type-override\"";
    }
    private static final AtomicBoolean typeConversionFallback_$Once = new AtomicBoolean(false);
    @Override
    public final void connectionEstablished(final int connectionIndex, final String channel) {
        super.log.logf(FQCN, DEBUG, null, connectionEstablished2$str(), connectionIndex, channel);
    }
    protected String connectionEstablished2$str() {
        return "SRMSG17039: Connection '%d' with RabbitMQ broker established for channel `%s`";
    }
}
