/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMessage;
import io.smallrye.reactive.messaging.rabbitmq.OutgoingRabbitMQMetadata;
import io.smallrye.reactive.messaging.rabbitmq.tracing.TracingUtils;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.rabbitmq.RabbitMQMessage;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.microprofile.reactive.messaging.Message;

public class RabbitMQMessageConverter {
    private static final List<Class<?>> PRIMITIVES = Arrays.asList(String.class, UUID.class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Double.class, Float.class, Long.class);

    private RabbitMQMessageConverter() {
    }

    public static OutgoingRabbitMQMessage convert(Message<?> message, String exchange, String defaultRoutingKey, Optional<Long> defaultTtl, boolean isTracingEnabled, List<String> attributeHeaders) {
        AMQP.BasicProperties properties;
        Buffer body;
        Optional<RabbitMQMessage> rabbitMQMessage = RabbitMQMessageConverter.getRabbitMQMessage(message);
        String routingKey = RabbitMQMessageConverter.getRoutingKey(message).orElse(defaultRoutingKey);
        if (rabbitMQMessage.isPresent()) {
            body = rabbitMQMessage.get().body();
            BasicProperties sourceProperties = rabbitMQMessage.get().properties();
            HashMap<String, Object> sourceHeaders = new HashMap<String, Object>(sourceProperties.getHeaders());
            if (isTracingEnabled) {
                TracingUtils.createOutgoingTrace(message, sourceHeaders, exchange, routingKey, attributeHeaders);
            }
            String expiration = null != sourceProperties.getExpiration() ? sourceProperties.getExpiration() : (String)defaultTtl.map(String::valueOf).orElse(null);
            String contentType = sourceProperties.getContentType() != null ? sourceProperties.getContentType() : RabbitMQMessageConverter.getDefaultContentTypeForPayload(message.getPayload());
            properties = new AMQP.BasicProperties.Builder().contentType(contentType).contentEncoding(sourceProperties.getContentEncoding()).headers(sourceHeaders).deliveryMode(sourceProperties.getDeliveryMode()).priority(sourceProperties.getPriority()).correlationId(sourceProperties.getCorrelationId()).replyTo(sourceProperties.getReplyTo()).expiration(expiration).messageId(sourceProperties.getMessageId()).timestamp(sourceProperties.getTimestamp()).type(sourceProperties.getType()).userId(sourceProperties.getUserId()).appId(sourceProperties.getAppId()).build();
        } else {
            String defaultContentType = RabbitMQMessageConverter.getDefaultContentTypeForPayload(message.getPayload());
            body = RabbitMQMessageConverter.getBodyFromPayload(message.getPayload());
            OutgoingRabbitMQMetadata metadata = message.getMetadata(OutgoingRabbitMQMetadata.class).orElse(new OutgoingRabbitMQMetadata.Builder().withContentType(defaultContentType).withExpiration(defaultTtl.map(String::valueOf).orElse(null)).build());
            if (isTracingEnabled) {
                TracingUtils.createOutgoingTrace(message, metadata.getHeaders(), exchange, routingKey, attributeHeaders);
            }
            Date timestamp = metadata.getTimestamp() != null ? Date.from(metadata.getTimestamp().toInstant()) : null;
            String contentType = metadata.getContentType() != null ? metadata.getContentType() : defaultContentType;
            properties = new AMQP.BasicProperties.Builder().contentType(contentType).contentEncoding(metadata.getContentEncoding()).headers(metadata.getHeaders()).deliveryMode(metadata.getDeliveryMode()).priority(metadata.getPriority()).correlationId(metadata.getCorrelationId()).replyTo(metadata.getReplyTo()).expiration(metadata.getExpiration()).messageId(metadata.getMessageId()).timestamp(timestamp).type(metadata.getType()).userId(metadata.getUserId()).appId(metadata.getAppId()).clusterId(metadata.getClusterId()).build();
        }
        return new OutgoingRabbitMQMessage(routingKey, body, (BasicProperties)properties);
    }

    private static Buffer getBodyFromPayload(Object payload) {
        if (RabbitMQMessageConverter.isPrimitive(payload.getClass())) {
            return Buffer.buffer((String)payload.toString());
        }
        if (payload instanceof Buffer) {
            return (Buffer)payload;
        }
        if (payload instanceof io.vertx.core.buffer.Buffer) {
            return Buffer.buffer((byte[])((io.vertx.core.buffer.Buffer)payload).getBytes());
        }
        if (payload instanceof byte[]) {
            return Buffer.buffer((byte[])((byte[])payload));
        }
        if (payload instanceof JsonObject) {
            return Buffer.buffer((String)((JsonObject)payload).encode());
        }
        if (payload instanceof JsonArray) {
            return Buffer.buffer((String)((JsonArray)payload).encode());
        }
        return Buffer.buffer((String)Json.encode((Object)payload));
    }

    private static String getDefaultContentTypeForPayload(Object payload) {
        if (RabbitMQMessageConverter.isPrimitive(payload.getClass())) {
            return HttpHeaderValues.TEXT_PLAIN.toString();
        }
        if (payload instanceof Buffer) {
            return HttpHeaderValues.APPLICATION_OCTET_STREAM.toString();
        }
        if (payload instanceof io.vertx.core.buffer.Buffer) {
            return HttpHeaderValues.APPLICATION_OCTET_STREAM.toString();
        }
        if (payload instanceof byte[]) {
            return HttpHeaderValues.APPLICATION_OCTET_STREAM.toString();
        }
        if (payload instanceof JsonObject) {
            return HttpHeaderValues.APPLICATION_JSON.toString();
        }
        if (payload instanceof JsonArray) {
            return HttpHeaderValues.APPLICATION_JSON.toString();
        }
        return HttpHeaderValues.APPLICATION_JSON.toString();
    }

    private static Optional<RabbitMQMessage> getRabbitMQMessage(Message<?> message) {
        if (message instanceof IncomingRabbitMQMessage) {
            return Optional.of(((IncomingRabbitMQMessage)message).getRabbitMQMessage());
        }
        if (message.getPayload() instanceof RabbitMQMessage) {
            return Optional.of((RabbitMQMessage)message.getPayload());
        }
        if (message.getPayload() instanceof io.vertx.rabbitmq.RabbitMQMessage) {
            return Optional.of(new RabbitMQMessage((io.vertx.rabbitmq.RabbitMQMessage)message.getPayload()));
        }
        return Optional.empty();
    }

    private static Optional<String> getRoutingKey(Message<?> message) {
        Optional<RabbitMQMessage> rabbitMQMessage = RabbitMQMessageConverter.getRabbitMQMessage(message);
        if (rabbitMQMessage.isPresent()) {
            return Optional.of(rabbitMQMessage.get().envelope().getRoutingKey());
        }
        OutgoingRabbitMQMetadata metadata = message.getMetadata(OutgoingRabbitMQMetadata.class).orElse(new OutgoingRabbitMQMetadata());
        return Optional.ofNullable(metadata.getRoutingKey());
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || PRIMITIVES.contains(clazz);
    }

    public static final class OutgoingRabbitMQMessage {
        private final String routingKey;
        private final Buffer body;
        private final BasicProperties properties;

        private OutgoingRabbitMQMessage(String routingKey, Buffer body, BasicProperties properties) {
            this.routingKey = routingKey;
            this.body = body;
            this.properties = properties;
        }

        public Buffer getBody() {
            return this.body;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public BasicProperties getProperties() {
            return this.properties;
        }
    }
}

