/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.fault;

import io.smallrye.reactive.messaging.rabbitmq.ConnectionHolder;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMessage;
import io.smallrye.reactive.messaging.rabbitmq.fault.RabbitMQFailureHandler;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.mutiny.core.Context;
import java.util.concurrent.CompletionStage;

public class RabbitMQReject
implements RabbitMQFailureHandler {
    private final String channel;

    public RabbitMQReject(String channel) {
        this.channel = channel;
    }

    @Override
    public <V> CompletionStage<Void> handle(IncomingRabbitMQMessage<V> msg, Context context, Throwable reason) {
        RabbitMQLogging.log.nackedIgnoreMessage(this.channel);
        RabbitMQLogging.log.fullIgnoredFailure(reason);
        return ConnectionHolder.runOnContext(context, msg, m -> m.rejectMessage(reason));
    }
}

