|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *addresses* _(rabbitmq-addresses)_ | The multiple addresses for cluster mode, when given overrides the host and port | string | false |  |
| *automatic-recovery-enabled* | Whether automatic connection recovery is enabled | boolean | false | `false` |
| *automatic-recovery-on-initial-connection* | Whether automatic recovery on initial connections is enabled | boolean | false | `true` |
| *client-options-name* _(rabbitmq-client-options-name)_ | The name of the RabbitMQ Client Option bean used to customize the RabbitMQ client configuration | string | false |  |
| *connection-timeout* | The TCP connection timeout (ms); 0 is interpreted as no timeout | int | false | `60000` |
| *credentials-provider-name* _(rabbitmq-credentials-provider-name)_ | The name of the RabbitMQ Credentials Provider bean used to provide dynamic credentials to the RabbitMQ client | string | false |  |
| *default-routing-key* | The default routing key to use when sending messages to the exchange | string | false | `` |
| *default-ttl* | If specified, the time (ms) sent messages can remain in queues undelivered before they are dead | long | false |  |
| *exchange.arguments* | The identifier of the key-value Map exposed as bean used to provide arguments for exchange creation | string | false | `rabbitmq-exchange-arguments` |
| *exchange.auto-delete* | Whether the exchange should be deleted after use | boolean | false | `false` |
| *exchange.declare* | Whether to declare the exchange; set to false if the exchange is expected to be set up independently | boolean | false | `true` |
| *exchange.durable* | Whether the exchange is durable | boolean | false | `true` |
| *exchange.name* | The exchange that messages are published to or consumed from. If not set, the channel name is used. If set to "", the default exchange is used. | string | false |  |
| *exchange.type* | The exchange type: direct, fanout, headers or topic (default) | string | false | `topic` |
| *handshake-timeout* | The AMQP 0-9-1 protocol handshake timeout (ms) | int | false | `10000` |
| *health-enabled* | Whether health reporting is enabled (default) or disabled | boolean | false | `true` |
| *health-readiness-enabled* | Whether readiness health reporting is enabled (default) or disabled | boolean | false | `true` |
| *host* _(rabbitmq-host)_ | The broker hostname | string | false | `localhost` |
| *include-properties* | Whether to include properties when a broker message is passed on the event bus | boolean | false | `false` |
| *max-inflight-messages* | The maximum number of messages to be written to RabbitMQ concurrently; must be a positive number | long | false | `1024` |
| *max-outgoing-internal-queue-size* | The maximum size of the outgoing internal queue | int | false |  |
| *network-recovery-interval* | How long (ms) will automatic recovery wait before attempting to reconnect | int | false | `5000` |
| *password* _(rabbitmq-password)_ | The password used to authenticate to the broker | string | false |  |
| *port* _(rabbitmq-port)_ | The broker port | int | false | `5672` |
| *publish-confirms* | If set to true, published messages are acknowledged when the publish confirm is received from the broker | boolean | false | `false` |
| *reconnect-attempts* _(rabbitmq-reconnect-attempts)_ | The number of reconnection attempts | int | false | `100` |
| *reconnect-interval* _(rabbitmq-reconnect-interval)_ | The interval (in seconds) between two reconnection attempts | int | false | `10` |
| *requested-channel-max* | The initially requested maximum channel number | int | false | `2047` |
| *requested-heartbeat* | The initially requested heartbeat interval (seconds), zero for none | int | false | `60` |
| *ssl* _(rabbitmq-ssl)_ | Whether or not the connection should use SSL | boolean | false | `false` |
| *tracing.attribute-headers* | A comma-separated list of headers that should be recorded as span attributes. Relevant only if tracing.enabled=true | string | false | `` |
| *tracing.enabled* | Whether tracing is enabled (default) or disabled | boolean | false | `true` |
| *trust-all* _(rabbitmq-trust-all)_ | Whether to skip trust certificate verification | boolean | false | `false` |
| *trust-store-password* _(rabbitmq-trust-store-password)_ | The password of the JKS trust store | string | false |  |
| *trust-store-path* _(rabbitmq-trust-store-path)_ | The path to a JKS trust store | string | false |  |
| *use-nio* | Whether usage of NIO Sockets is enabled | boolean | false | `false` |
| *user* | The user name to use when connecting to the broker | string | false | `guest` |
| *username* _(rabbitmq-username)_ | The username used to authenticate to the broker | string | false |  |
| *virtual-host* _(rabbitmq-virtual-host)_ | The virtual host to use when connecting to the broker | string | false | `/` |
