/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class RabbitMQConnectorCommonConfiguration {
    protected final Config config;

    public RabbitMQConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public Optional<String> getUsername() {
        Optional maybe = this.config.getOptionalValue("username", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("rabbitmq-username", String.class);
    }

    public Optional<String> getPassword() {
        Optional maybe = this.config.getOptionalValue("password", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("rabbitmq-password", String.class);
    }

    public String getHost() {
        return this.config.getOptionalValue("host", String.class).orElseGet(() -> this.getFromAliasWithDefaultValue("rabbitmq-host", String.class, "localhost"));
    }

    public Integer getPort() {
        return this.config.getOptionalValue("port", Integer.class).orElseGet(() -> this.getFromAliasWithDefaultValue("rabbitmq-port", Integer.class, Integer.valueOf("5672")));
    }

    public Optional<String> getAddresses() {
        Optional maybe = this.config.getOptionalValue("addresses", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("rabbitmq-addresses", String.class);
    }

    public Boolean getSsl() {
        return this.config.getOptionalValue("ssl", Boolean.class).orElseGet(() -> this.getFromAliasWithDefaultValue("rabbitmq-ssl", Boolean.class, Boolean.valueOf("false")));
    }

    public Boolean getTrustAll() {
        return this.config.getOptionalValue("trust-all", Boolean.class).orElseGet(() -> this.getFromAliasWithDefaultValue("rabbitmq-trust-all", Boolean.class, Boolean.valueOf("false")));
    }

    public Optional<String> getTrustStorePath() {
        Optional maybe = this.config.getOptionalValue("trust-store-path", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("rabbitmq-trust-store-path", String.class);
    }

    public Optional<String> getTrustStorePassword() {
        Optional maybe = this.config.getOptionalValue("trust-store-password", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("rabbitmq-trust-store-password", String.class);
    }

    public Integer getConnectionTimeout() {
        return this.config.getOptionalValue("connection-timeout", Integer.class).orElse(Integer.valueOf("60000"));
    }

    public Integer getHandshakeTimeout() {
        return this.config.getOptionalValue("handshake-timeout", Integer.class).orElse(Integer.valueOf("10000"));
    }

    public Boolean getAutomaticRecoveryEnabled() {
        return this.config.getOptionalValue("automatic-recovery-enabled", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Boolean getAutomaticRecoveryOnInitialConnection() {
        return this.config.getOptionalValue("automatic-recovery-on-initial-connection", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Integer getReconnectAttempts() {
        return this.config.getOptionalValue("reconnect-attempts", Integer.class).orElseGet(() -> this.getFromAliasWithDefaultValue("rabbitmq-reconnect-attempts", Integer.class, Integer.valueOf("100")));
    }

    public Integer getReconnectInterval() {
        return this.config.getOptionalValue("reconnect-interval", Integer.class).orElseGet(() -> this.getFromAliasWithDefaultValue("rabbitmq-reconnect-interval", Integer.class, Integer.valueOf("10")));
    }

    public Integer getNetworkRecoveryInterval() {
        return this.config.getOptionalValue("network-recovery-interval", Integer.class).orElse(Integer.valueOf("5000"));
    }

    public String getUser() {
        return this.config.getOptionalValue("user", String.class).orElse("guest");
    }

    public Boolean getIncludeProperties() {
        return this.config.getOptionalValue("include-properties", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Integer getRequestedChannelMax() {
        return this.config.getOptionalValue("requested-channel-max", Integer.class).orElse(Integer.valueOf("2047"));
    }

    public Integer getRequestedHeartbeat() {
        return this.config.getOptionalValue("requested-heartbeat", Integer.class).orElse(Integer.valueOf("60"));
    }

    public Boolean getUseNio() {
        return this.config.getOptionalValue("use-nio", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getVirtualHost() {
        return this.config.getOptionalValue("virtual-host", String.class).orElseGet(() -> this.getFromAliasWithDefaultValue("rabbitmq-virtual-host", String.class, "/"));
    }

    public Optional<String> getClientOptionsName() {
        Optional maybe = this.config.getOptionalValue("client-options-name", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("rabbitmq-client-options-name", String.class);
    }

    public Optional<String> getCredentialsProviderName() {
        Optional maybe = this.config.getOptionalValue("credentials-provider-name", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("rabbitmq-credentials-provider-name", String.class);
    }

    public Boolean getHealthEnabled() {
        return this.config.getOptionalValue("health-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getHealthReadinessEnabled() {
        return this.config.getOptionalValue("health-readiness-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Optional<String> getExchangeName() {
        return this.config.getOptionalValue("exchange.name", String.class);
    }

    public Boolean getExchangeDurable() {
        return this.config.getOptionalValue("exchange.durable", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getExchangeAutoDelete() {
        return this.config.getOptionalValue("exchange.auto-delete", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getExchangeType() {
        return this.config.getOptionalValue("exchange.type", String.class).orElse("topic");
    }

    public Boolean getExchangeDeclare() {
        return this.config.getOptionalValue("exchange.declare", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public String getExchangeArguments() {
        return this.config.getOptionalValue("exchange.arguments", String.class).orElse("rabbitmq-exchange-arguments");
    }

    public Boolean getTracingEnabled() {
        return this.config.getOptionalValue("tracing.enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public String getTracingAttributeHeaders() {
        return this.config.getOptionalValue("tracing.attribute-headers", String.class).orElse("");
    }

    public void validate() {
    }
}

