/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import io.smallrye.reactive.messaging.rabbitmq.tracing.RabbitMQTrace;

public class RabbitMQTraceAttributesExtractor
implements AttributesExtractor<RabbitMQTrace, Void> {
    private final MessagingAttributesGetter<RabbitMQTrace, Void> messagingAttributesGetter = new RabbitMQMessagingAttributesGetter();

    public MessagingAttributesGetter<RabbitMQTrace, Void> getMessagingAttributesGetter() {
        return this.messagingAttributesGetter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, RabbitMQTrace rabbitMQTrace) {
        attributes.put(SemanticAttributes.MESSAGING_RABBITMQ_ROUTING_KEY, (Object)rabbitMQTrace.getRoutingKey());
    }

    public void onEnd(AttributesBuilder attributes, Context context, RabbitMQTrace rabbitMQTrace, Void unused, Throwable error) {
    }

    private static final class RabbitMQMessagingAttributesGetter
    implements MessagingAttributesGetter<RabbitMQTrace, Void> {
        private RabbitMQMessagingAttributesGetter() {
        }

        public String getSystem(RabbitMQTrace rabbitMQTrace) {
            return "rabbitmq";
        }

        public String getDestination(RabbitMQTrace rabbitMQTrace) {
            return rabbitMQTrace.getDestination();
        }

        public boolean isTemporaryDestination(RabbitMQTrace rabbitMQTrace) {
            return false;
        }

        public String getConversationId(RabbitMQTrace rabbitMQTrace) {
            return null;
        }

        public Long getMessagePayloadSize(RabbitMQTrace rabbitMQTrace) {
            return null;
        }

        public Long getMessagePayloadCompressedSize(RabbitMQTrace rabbitMQTrace) {
            return null;
        }

        public String getMessageId(RabbitMQTrace rabbitMQTrace, Void unused) {
            return null;
        }
    }
}

