/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.i18n;

import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class RabbitMQLogging_$logger
extends DelegatingBasicLogger
implements RabbitMQLogging,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RabbitMQLogging_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean typeConversionFallback_$Once = new AtomicBoolean(false);

    public RabbitMQLogging_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void receiverListeningAddress(String address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.receiverListeningAddress$str(), (Object)address);
    }

    protected String receiverListeningAddress$str() {
        return "SRMSG17000: RabbitMQ Receiver listening address %s";
    }

    @Override
    public final void receiverError(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.receiverError$str(), new Object[0]);
    }

    protected String receiverError$str() {
        return "SRMSG17001: RabbitMQ Receiver error";
    }

    @Override
    public final void retrieveMessagesRetrying(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.retrieveMessagesRetrying$str(), new Object[0]);
    }

    protected String retrieveMessagesRetrying$str() {
        return "SRMSG17002: Unable to retrieve messages from RabbitMQ, retrying...";
    }

    @Override
    public final void retrieveMessagesNoMoreRetrying(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.retrieveMessagesNoMoreRetrying$str(), new Object[0]);
    }

    protected String retrieveMessagesNoMoreRetrying$str() {
        return "SRMSG17003: Unable to retrieve messages from RabbitMQ, no more retry";
    }

    @Override
    public final void establishingConnection(String channel) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.establishingConnection$str(), (Object)channel);
    }

    protected String establishingConnection$str() {
        return "SRMSG17006: Establishing connection with RabbitMQ broker for channel `%s`";
    }

    @Override
    public final void connectionEstablished(String channel) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectionEstablished$str(), (Object)channel);
    }

    protected String connectionEstablished$str() {
        return "SRMSG17007: Connection with RabbitMQ broker established for channel `%s`";
    }

    @Override
    public final void unableToConnectToBroker(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToConnectToBroker$str(), new Object[0]);
    }

    protected String unableToConnectToBroker$str() {
        return "SRMSG17008: Unable to connect to the broker, retry will be attempted";
    }

    @Override
    public final void unableToRecoverFromConnectionDisruption(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToRecoverFromConnectionDisruption$str(), new Object[0]);
    }

    protected String unableToRecoverFromConnectionDisruption$str() {
        return "SRMSG17009: Unable to recover from RabbitMQ connection disruption";
    }

    @Override
    public final void nackedAcceptMessage(String channel) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.nackedAcceptMessage$str(), (Object)channel);
    }

    protected String nackedAcceptMessage$str() {
        return "SRMSG17010: A message sent to channel `%s` has been nacked, ignoring the failure and marking the RabbitMQ message as accepted";
    }

    @Override
    public final void fullIgnoredFailure(Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.fullIgnoredFailure$str(), new Object[0]);
    }

    protected String fullIgnoredFailure$str() {
        return "SRMSG17011: The full ignored failure is";
    }

    @Override
    public final void nackedFailMessage(String channel) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.nackedFailMessage$str(), (Object)channel);
    }

    protected String nackedFailMessage$str() {
        return "SRMSG17012: A message sent to channel `%s` has been nacked, rejecting the RabbitMQ message and fail-stop";
    }

    @Override
    public final void nackedIgnoreMessage(String channel) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.nackedIgnoreMessage$str(), (Object)channel);
    }

    protected String nackedIgnoreMessage$str() {
        return "SRMSG17013: A message sent to channel `%s` has been nacked, ignoring the failure and marking the RabbitMQ message as rejected";
    }

    @Override
    public final void failureReported(String channel, Throwable reason) {
        this.log.logf(FQCN, Logger.Level.ERROR, reason, this.failureReported$str(), (Object)channel);
    }

    protected String failureReported$str() {
        return "SRMSG17018: Failure reported for channel `%s`, closing client";
    }

    @Override
    public final void serializationFailure(String channel, Throwable reason) {
        this.log.logf(FQCN, Logger.Level.ERROR, reason, this.serializationFailure$str(), (Object)channel);
    }

    protected String serializationFailure$str() {
        return "SRMSG17021: Unable to serialize message on channel `%s`, message has been nacked";
    }

    @Override
    public final void sendingMessageToExchange(String exchange, String routingKey) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.sendingMessageToExchange$str(), (Object)exchange, (Object)routingKey);
    }

    protected String sendingMessageToExchange$str() {
        return "SRMSG17022: Sending a message to exchange `%s` with routing key %s";
    }

    @Override
    public final void exchangeEstablished(String exchangeName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.exchangeEstablished$str(), (Object)exchangeName);
    }

    protected String exchangeEstablished$str() {
        return "SRMSG17023: Established exchange `%s`";
    }

    @Override
    public final void unableToEstablishExchange(String exchangeName, Throwable ex) {
        this.log.logf(FQCN, Logger.Level.ERROR, ex, this.unableToEstablishExchange$str(), (Object)exchangeName);
    }

    protected String unableToEstablishExchange$str() {
        return "SRMSG17024: Unable to establish exchange `%s`";
    }

    @Override
    public final void queueEstablished(String queueName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.queueEstablished$str(), (Object)queueName);
    }

    protected String queueEstablished$str() {
        return "SRMSG17025: Established queue `%s`";
    }

    @Override
    public final void unableToEstablishBinding(String queueName, String exchangeName, Throwable ex) {
        this.log.logf(FQCN, Logger.Level.ERROR, ex, this.unableToEstablishBinding$str(), (Object)queueName, (Object)exchangeName);
    }

    protected String unableToEstablishBinding$str() {
        return "SRMSG17026: Unable to bind queue '%s' to exchange '%s'";
    }

    @Override
    public final void bindingEstablished(String queueName, String exchangeName, String routingKey, String arguments) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.bindingEstablished$str(), new Object[]{queueName, exchangeName, routingKey, arguments});
    }

    protected String bindingEstablished$str() {
        return "SRMSG17027: Established binding of queue `%s` to exchange '%s' using routing key '%s' and arguments '%s'";
    }

    @Override
    public final void unableToEstablishQueue(String exchangeName, Throwable ex) {
        this.log.logf(FQCN, Logger.Level.ERROR, ex, this.unableToEstablishQueue$str(), (Object)exchangeName);
    }

    protected String unableToEstablishQueue$str() {
        return "SRMSG17028: Unable to establish queue `%s`";
    }

    @Override
    public final void dlxEstablished(String deadLetterExchangeName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.dlxEstablished$str(), (Object)deadLetterExchangeName);
    }

    protected String dlxEstablished$str() {
        return "SRMSG17029: Established dlx `%s`";
    }

    @Override
    public final void unableToEstablishDlx(String deadLetterExchangeName, Throwable ex) {
        this.log.logf(FQCN, Logger.Level.ERROR, ex, this.unableToEstablishDlx$str(), (Object)deadLetterExchangeName);
    }

    protected String unableToEstablishDlx$str() {
        return "SRMSG17030: Unable to establish dlx `%s`";
    }

    @Override
    public final void ackMessage(String channel) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.ackMessage$str(), (Object)channel);
    }

    protected String ackMessage$str() {
        return "SRMSG17033: A message sent to channel `%s` has been ack'd";
    }

    @Override
    public final void ackAutoMessage(String channel) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.ackAutoMessage$str(), (Object)channel);
    }

    protected String ackAutoMessage$str() {
        return "SRMSG17034: A message sent to channel `%s` has not been explicitly ack'd as auto-ack is enabled";
    }

    @Override
    public final void createClientFromBean(String optionsBeanName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createClientFromBean$str(), (Object)optionsBeanName);
    }

    protected String createClientFromBean$str() {
        return "SRMSG17035: Creating RabbitMQ client from bean named '%s'";
    }

    @Override
    public final void brokerConfigured(String address, String channel) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.brokerConfigured$str(), (Object)address, (Object)channel);
    }

    protected String brokerConfigured$str() {
        return "SRMSG17036: RabbitMQ broker configured to %s for channel %s";
    }

    @Override
    public final void unableToCreateClient(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unableToCreateClient$str(), new Object[0]);
    }

    protected String unableToCreateClient$str() {
        return "SRMSG17037: Unable to create client";
    }

    @Override
    public final void typeConversionFallback() {
        if (this.log.isEnabled(Logger.Level.WARN) && typeConversionFallback_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.typeConversionFallback$str(), new Object[0]);
        }
    }

    protected String typeConversionFallback$str() {
        return "SRMSG17038: No valid content_type set, failing back to byte[]. If that's wanted, set the content type to application/octet-stream with \"content-type-override\"";
    }

    @Override
    public final void deadLetterBindingEstablished(String queueName, String exchangeName, String routingKey) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.deadLetterBindingEstablished$str(), (Object)queueName, (Object)exchangeName, (Object)routingKey);
    }

    protected String deadLetterBindingEstablished$str() {
        return "SRMSG17040: Established dead letter binding of queue `%s` to exchange '%s' using routing key '%s'";
    }
}

