/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.internals;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import com.rabbitmq.client.impl.DefaultCredentialsRefreshService;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnector;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQExceptions;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.rabbitmq.RabbitMQClient;
import io.vertx.rabbitmq.RabbitMQOptions;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;

public class RabbitMQClientHelper {
    private static final double CREDENTIALS_PROVIDER_REFRESH_DELAY_RATIO = 0.8;
    private static final Duration CREDENTIALS_PROVIDER_APPROACH_EXPIRE_TIME = Duration.ofSeconds(1L);

    private RabbitMQClientHelper() {
    }

    static RabbitMQClient createClient(RabbitMQConnector connector, RabbitMQConnectorCommonConfiguration config) {
        Optional<String> clientOptionsName = config.getClientOptionsName();
        Vertx vertx = connector.vertx();
        try {
            RabbitMQOptions options = clientOptionsName.isPresent() ? RabbitMQClientHelper.getClientOptionsFromBean(connector.clientOptions(), clientOptionsName.get()) : RabbitMQClientHelper.getClientOptions(vertx, config, connector.credentialsProviders());
            if ("".equals(options.getMetricsName())) {
                options.setMetricsName("rabbitmq|" + config.getChannel());
            }
            RabbitMQClient client = RabbitMQClient.create((Vertx)vertx, (RabbitMQOptions)options);
            connector.registerClient(config.getChannel(), client);
            return client;
        }
        catch (Exception e) {
            RabbitMQLogging.log.unableToCreateClient(e);
            throw RabbitMQExceptions.ex.illegalStateUnableToCreateClient(e);
        }
    }

    static RabbitMQOptions getClientOptionsFromBean(Instance<RabbitMQOptions> options, String optionsBeanName) {
        if ((options = options.select(new Annotation[]{Identifier.Literal.of((String)optionsBeanName)})).isUnsatisfied() && !(options = options.select(new Annotation[]{NamedLiteral.of((String)optionsBeanName)})).isUnsatisfied()) {
            ProviderLogging.log.deprecatedNamed();
        }
        if (!options.isResolvable()) {
            throw RabbitMQExceptions.ex.illegalStateFindingBean(RabbitMQOptions.class.getName(), optionsBeanName);
        }
        RabbitMQLogging.log.createClientFromBean(optionsBeanName);
        return (RabbitMQOptions)options.get();
    }

    static RabbitMQOptions getClientOptions(Vertx vertx, RabbitMQConnectorCommonConfiguration config, Instance<CredentialsProvider> credentialsProviders) {
        String connectionName = String.format("%s (%s)", config.getChannel(), config instanceof RabbitMQConnectorIncomingConfiguration ? "Incoming" : "Outgoing");
        List addresses = config.getAddresses().map(s -> Arrays.asList(Address.parseAddresses((String)s))).orElseGet(() -> Collections.singletonList(new Address(config.getHost(), config.getPort().intValue())));
        RabbitMQLogging.log.brokerConfigured(addresses.toString(), config.getChannel());
        RabbitMQOptions options = new RabbitMQOptions().setConnectionName(connectionName).setAddresses(addresses).setSsl(config.getSsl().booleanValue()).setTrustAll(config.getTrustAll().booleanValue()).setAutomaticRecoveryEnabled(config.getAutomaticRecoveryEnabled().booleanValue()).setAutomaticRecoveryOnInitialConnection(config.getAutomaticRecoveryOnInitialConnection().booleanValue()).setReconnectAttempts(config.getReconnectAttempts().intValue()).setReconnectInterval(Duration.ofSeconds(config.getReconnectInterval().intValue()).toMillis()).setConnectionTimeout(config.getConnectionTimeout().intValue()).setHandshakeTimeout(config.getHandshakeTimeout().intValue()).setIncludeProperties(config.getIncludeProperties().booleanValue()).setNetworkRecoveryInterval((long)config.getNetworkRecoveryInterval().intValue()).setRequestedChannelMax(config.getRequestedChannelMax().intValue()).setRequestedHeartbeat(config.getRequestedHeartbeat().intValue()).setUseNio(config.getUseNio().booleanValue()).setVirtualHost(config.getVirtualHost());
        if ("NONE".equals(config.getSslHostnameVerificationAlgorithm())) {
            options.setHostnameVerificationAlgorithm("");
        } else {
            options.setHostnameVerificationAlgorithm(config.getSslHostnameVerificationAlgorithm());
        }
        Optional<String> trustStorePath = config.getTrustStorePath();
        if (trustStorePath.isPresent()) {
            JksOptions jks = new JksOptions();
            jks.setPath(trustStorePath.get());
            config.getTrustStorePassword().ifPresent(arg_0 -> ((JksOptions)jks).setPassword(arg_0));
            options.setTrustStoreOptions(jks);
        }
        if (config.getCredentialsProviderName().isPresent()) {
            String credentialsProviderName = config.getCredentialsProviderName().get();
            if ((credentialsProviders = credentialsProviders.select(new Annotation[]{Identifier.Literal.of((String)credentialsProviderName)})).isUnsatisfied() && !(credentialsProviders = credentialsProviders.select(new Annotation[]{NamedLiteral.of((String)credentialsProviderName)})).isUnsatisfied()) {
                ProviderLogging.log.deprecatedNamed();
            }
            if (!credentialsProviders.isResolvable()) {
                throw RabbitMQExceptions.ex.illegalStateFindingBean(CredentialsProvider.class.getName(), credentialsProviderName);
            }
            CredentialsProvider credentialsProvider = (CredentialsProvider)credentialsProviders.get();
            options.setCredentialsProvider(credentialsProvider);
            options.setCredentialsRefreshService((CredentialsRefreshService)new DefaultCredentialsRefreshService((ScheduledExecutorService)vertx.nettyEventLoopGroup(), DefaultCredentialsRefreshService.ratioRefreshDelayStrategy((double)0.8), DefaultCredentialsRefreshService.fixedTimeApproachingExpirationStrategy((Duration)CREDENTIALS_PROVIDER_APPROACH_EXPIRE_TIME)));
        } else {
            String username = config.getUsername().orElse("guest");
            String password = config.getPassword().orElse("guest");
            options.setUser(username);
            options.setPassword(password);
        }
        return options;
    }

    public static String serverQueueName(String name) {
        if (name.equals("(server.auto)")) {
            return "";
        }
        return name;
    }

    public static Map<String, Object> parseArguments(Optional<String> argumentsConfig) {
        HashMap<String, Object> argumentsBinding = new HashMap<String, Object>();
        if (argumentsConfig.isPresent()) {
            for (String segment : argumentsConfig.get().split(",")) {
                String[] argumentKeyValueSplit = segment.trim().split(":");
                if (argumentKeyValueSplit.length != 2) continue;
                String key = argumentKeyValueSplit[0];
                String value = argumentKeyValueSplit[1];
                try {
                    argumentsBinding.put(key, Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    argumentsBinding.put(key, value);
                }
            }
        }
        return argumentsBinding;
    }

    public static Uni<String> declareExchangeIfNeeded(RabbitMQClient client, RabbitMQConnectorCommonConfiguration config, Instance<Map<String, ?>> configMaps) {
        boolean declareExchange;
        String exchangeName = RabbitMQClientHelper.getExchangeName(config);
        JsonObject queueArgs = new JsonObject();
        Instance queueArguments = CDIUtils.getInstanceById(configMaps, (String)config.getExchangeArguments());
        if (queueArguments.isResolvable()) {
            Map argsMap = (Map)queueArguments.get();
            argsMap.forEach((arg_0, arg_1) -> ((JsonObject)queueArgs).put(arg_0, arg_1));
        }
        boolean bl = declareExchange = config.getExchangeDeclare() != false && !exchangeName.isEmpty();
        if (declareExchange) {
            return client.exchangeDeclare(exchangeName, config.getExchangeType(), config.getExchangeDurable().booleanValue(), config.getExchangeAutoDelete().booleanValue(), queueArgs).replaceWith((Object)exchangeName).invoke(() -> RabbitMQLogging.log.exchangeEstablished(exchangeName)).onFailure().invoke(ex -> RabbitMQLogging.log.unableToEstablishExchange(exchangeName, (Throwable)ex));
        }
        return Uni.createFrom().item((Object)exchangeName);
    }

    public static String getExchangeName(RabbitMQConnectorCommonConfiguration config) {
        return config.getExchangeName().map(s -> "\"\"".equals(s) ? "" : s).orElse(config.getChannel());
    }

    static Uni<?> configureDLQorDLX(RabbitMQClient client, RabbitMQConnectorIncomingConfiguration ic, Instance<Map<String, ?>> configMaps) {
        String deadLetterQueueName = ic.getDeadLetterQueueName().orElse(String.format("%s.dlq", RabbitMQClientHelper.getQueueName(ic)));
        String deadLetterExchangeName = ic.getDeadLetterExchange();
        String deadLetterRoutingKey = ic.getDeadLetterRoutingKey().orElse(RabbitMQClientHelper.getQueueName(ic));
        JsonObject exchangeArgs = new JsonObject();
        ic.getDeadLetterExchangeArguments().ifPresent(argsId -> {
            Instance exchangeArguments = CDIUtils.getInstanceById((Instance)configMaps, (String)argsId);
            if (exchangeArguments.isResolvable()) {
                Map argsMap = (Map)exchangeArguments.get();
                argsMap.forEach((arg_0, arg_1) -> ((JsonObject)exchangeArgs).put(arg_0, arg_1));
            }
        });
        Uni dlxFlow = Uni.createFrom().item(() -> ic.getAutoBindDlq() != false && ic.getDlxDeclare() != false ? null : deadLetterExchangeName).onItem().ifNull().switchTo(() -> client.exchangeDeclare(deadLetterExchangeName, ic.getDeadLetterExchangeType(), true, false, exchangeArgs).onItem().invoke(() -> RabbitMQLogging.log.dlxEstablished(deadLetterExchangeName)).onFailure().invoke(ex -> RabbitMQLogging.log.unableToEstablishDlx(deadLetterExchangeName, (Throwable)ex)).onItem().transform(v -> deadLetterExchangeName));
        JsonObject queueArgs = new JsonObject();
        ic.getDeadLetterQueueArguments().ifPresent(argsId -> {
            Instance queueArguments = CDIUtils.getInstanceById((Instance)configMaps, (String)argsId);
            if (queueArguments.isResolvable()) {
                Map argsMap = (Map)queueArguments.get();
                argsMap.forEach((arg_0, arg_1) -> ((JsonObject)queueArgs).put(arg_0, arg_1));
            }
        });
        ic.getDeadLetterDlx().ifPresent(deadLetterDlx -> queueArgs.put("x-dead-letter-exchange", deadLetterDlx));
        ic.getDeadLetterDlxRoutingKey().ifPresent(deadLetterDlx -> queueArgs.put("x-dead-letter-routing-key", deadLetterDlx));
        ic.getDeadLetterQueueType().ifPresent(queueType -> queueArgs.put("x-queue-type", queueType));
        ic.getDeadLetterQueueMode().ifPresent(queueMode -> queueArgs.put("x-queue-mode", queueMode));
        ic.getDeadLetterTtl().ifPresent(queueTtl -> {
            if (queueTtl < 0L) {
                throw RabbitMQExceptions.ex.illegalArgumentInvalidQueueTtl();
            }
            queueArgs.put("x-message-ttl", queueTtl);
        });
        return dlxFlow.onItem().transform(v -> Boolean.TRUE.equals(ic.getAutoBindDlq()) ? null : deadLetterQueueName).onItem().ifNull().switchTo(() -> client.queueDeclare(deadLetterQueueName, true, false, false, queueArgs).onItem().invoke(() -> RabbitMQLogging.log.queueEstablished(deadLetterQueueName)).onFailure().invoke(ex -> RabbitMQLogging.log.unableToEstablishQueue(deadLetterQueueName, (Throwable)ex)).onItem().call(v -> client.queueBind(deadLetterQueueName, deadLetterExchangeName, deadLetterRoutingKey)).onItem().invoke(() -> RabbitMQLogging.log.deadLetterBindingEstablished(deadLetterQueueName, deadLetterExchangeName, deadLetterRoutingKey)).onFailure().invoke(ex -> RabbitMQLogging.log.unableToEstablishBinding(deadLetterQueueName, deadLetterExchangeName, (Throwable)ex)).onItem().transform(v -> deadLetterQueueName));
    }

    static Uni<List<String>> establishBindings(RabbitMQClient client, RabbitMQConnectorIncomingConfiguration ic) {
        String exchangeName = RabbitMQClientHelper.getExchangeName(ic);
        String queueName = RabbitMQClientHelper.getQueueName(ic);
        List routingKeys = Arrays.stream(ic.getRoutingKeys().split(",")).map(String::trim).collect(Collectors.toList());
        Map<String, Object> arguments = RabbitMQClientHelper.parseArguments(ic.getArguments());
        if (exchangeName.isEmpty()) {
            return Uni.createFrom().item(Collections.emptyList());
        }
        return Multi.createFrom().iterable(routingKeys).call(routingKey -> client.queueBind(RabbitMQClientHelper.serverQueueName(queueName), exchangeName, routingKey, arguments)).invoke(routingKey -> RabbitMQLogging.log.bindingEstablished(queueName, exchangeName, (String)routingKey, arguments.toString())).onFailure().invoke(ex -> RabbitMQLogging.log.unableToEstablishBinding(queueName, exchangeName, (Throwable)ex)).collect().asList();
    }

    public static String getQueueName(RabbitMQConnectorIncomingConfiguration config) {
        return config.getQueueName().orElse(config.getChannel());
    }
}

