/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq;

import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class RabbitMQConnectorIncomingConfiguration
extends RabbitMQConnectorCommonConfiguration {
    public RabbitMQConnectorIncomingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public Boolean getHealthLazySubscription() {
        return this.config.getOptionalValue("health-lazy-subscription", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Optional<String> getQueueName() {
        return this.config.getOptionalValue("queue.name", String.class);
    }

    public Boolean getQueueDurable() {
        return this.config.getOptionalValue("queue.durable", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getQueueExclusive() {
        return this.config.getOptionalValue("queue.exclusive", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Boolean getQueueAutoDelete() {
        return this.config.getOptionalValue("queue.auto-delete", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Boolean getQueueDeclare() {
        return this.config.getOptionalValue("queue.declare", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Optional<Long> getQueueTtl() {
        return this.config.getOptionalValue("queue.ttl", Long.class);
    }

    public Optional<Boolean> getQueueSingleActiveConsumer() {
        return this.config.getOptionalValue("queue.single-active-consumer", Boolean.class);
    }

    public Optional<String> getQueueXQueueType() {
        return this.config.getOptionalValue("queue.x-queue-type", String.class);
    }

    public Optional<String> getQueueXQueueMode() {
        return this.config.getOptionalValue("queue.x-queue-mode", String.class);
    }

    public Integer getMaxIncomingInternalQueueSize() {
        return this.config.getOptionalValue("max-incoming-internal-queue-size", Integer.class).orElse(Integer.valueOf("500000"));
    }

    public Optional<Integer> getQueueXMaxPriority() {
        return this.config.getOptionalValue("queue.x-max-priority", Integer.class);
    }

    public Optional<Long> getQueueXDeliveryLimit() {
        return this.config.getOptionalValue("queue.x-delivery-limit", Long.class);
    }

    public String getQueueArguments() {
        return this.config.getOptionalValue("queue.arguments", String.class).orElse("rabbitmq-queue-arguments");
    }

    public Boolean getAutoBindDlq() {
        return this.config.getOptionalValue("auto-bind-dlq", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Optional<String> getDeadLetterQueueName() {
        return this.config.getOptionalValue("dead-letter-queue-name", String.class);
    }

    public String getDeadLetterExchange() {
        return this.config.getOptionalValue("dead-letter-exchange", String.class).orElse("DLX");
    }

    public String getDeadLetterExchangeType() {
        return this.config.getOptionalValue("dead-letter-exchange-type", String.class).orElse("direct");
    }

    public Optional<String> getDeadLetterExchangeArguments() {
        return this.config.getOptionalValue("dead-letter-exchange.arguments", String.class);
    }

    public Optional<String> getDeadLetterRoutingKey() {
        return this.config.getOptionalValue("dead-letter-routing-key", String.class);
    }

    public Boolean getDlxDeclare() {
        return this.config.getOptionalValue("dlx.declare", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Optional<String> getDeadLetterQueueType() {
        return this.config.getOptionalValue("dead-letter-queue-type", String.class);
    }

    public Optional<String> getDeadLetterQueueMode() {
        return this.config.getOptionalValue("dead-letter-queue-mode", String.class);
    }

    public Optional<String> getDeadLetterQueueArguments() {
        return this.config.getOptionalValue("dead-letter-queue.arguments", String.class);
    }

    public Optional<Long> getDeadLetterTtl() {
        return this.config.getOptionalValue("dead-letter-ttl", Long.class);
    }

    public Optional<String> getDeadLetterDlx() {
        return this.config.getOptionalValue("dead-letter-dlx", String.class);
    }

    public Optional<String> getDeadLetterDlxRoutingKey() {
        return this.config.getOptionalValue("dead-letter-dlx-routing-key", String.class);
    }

    public String getFailureStrategy() {
        return this.config.getOptionalValue("failure-strategy", String.class).orElse("reject");
    }

    public Boolean getBroadcast() {
        return this.config.getOptionalValue("broadcast", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Boolean getAutoAcknowledgement() {
        return this.config.getOptionalValue("auto-acknowledgement", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Boolean getKeepMostRecent() {
        return this.config.getOptionalValue("keep-most-recent", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getRoutingKeys() {
        return this.config.getOptionalValue("routing-keys", String.class).orElse("#");
    }

    public Optional<String> getArguments() {
        return this.config.getOptionalValue("arguments", String.class);
    }

    public Optional<String> getConsumerArguments() {
        return this.config.getOptionalValue("consumer-arguments", String.class);
    }

    public Optional<String> getContentTypeOverride() {
        return this.config.getOptionalValue("content-type-override", String.class);
    }

    public Optional<Integer> getMaxOutstandingMessages() {
        return this.config.getOptionalValue("max-outstanding-messages", Integer.class);
    }

    @Override
    public void validate() {
        super.validate();
    }
}

